/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.element;

import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public class ExecutableFlowElementContainer
extends ExecutableActivity {
    private final List<ExecutableStartEvent> startEvents = new ArrayList<ExecutableStartEvent>();
    private final Map<DirectBuffer, AbstractFlowElement> childElements = new HashMap<DirectBuffer, AbstractFlowElement>();

    public ExecutableFlowElementContainer(String id) {
        super(id);
    }

    public ExecutableStartEvent getNoneStartEvent() {
        for (ExecutableStartEvent startEvent : this.startEvents) {
            if (!startEvent.isNone()) continue;
            return startEvent;
        }
        return null;
    }

    public List<ExecutableStartEvent> getStartEvents() {
        return this.startEvents;
    }

    public void addStartEvent(ExecutableStartEvent startEvent) {
        this.startEvents.add(startEvent);
    }

    public boolean hasNoneStartEvent() {
        return this.startEvents.stream().anyMatch(ExecutableCatchEvent::isNone);
    }

    public boolean hasMessageStartEvent() {
        return this.startEvents.stream().anyMatch(ExecutableCatchEventElement::isMessage);
    }

    public boolean hasTimerStartEvent() {
        return this.startEvents.stream().anyMatch(ExecutableCatchEventElement::isTimer);
    }

    public boolean hasSignalStartEvent() {
        return this.startEvents.stream().anyMatch(ExecutableCatchEventElement::isSignal);
    }

    public void addChildElement(AbstractFlowElement element) {
        this.childElements.put(element.getId(), element);
    }

    public Collection<AbstractFlowElement> getChildElements() {
        return this.childElements.values();
    }
}

