/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

public class EventSubProcessInterruptionMarker {
    private final ProcessState processState;
    private final MutableElementInstanceState elementInstanceState;

    public EventSubProcessInterruptionMarker(ProcessState processState, MutableElementInstanceState elementInstanceState) {
        this.processState = processState;
        this.elementInstanceState = elementInstanceState;
    }

    public void markInstanceIfInterrupted(long flowScopeElementInstanceKey, long processDefinitionKey, String tenantId, DirectBuffer elementId) {
        ExecutableFlowElement flowElement = this.processState.getFlowElement(processDefinitionKey, tenantId, elementId, ExecutableFlowElement.class);
        if (!this.isRootStartEvent(flowScopeElementInstanceKey) && flowElement.getFlowScope().getElementType() == BpmnElementType.EVENT_SUB_PROCESS && flowElement instanceof ExecutableStartEvent && ((ExecutableStartEvent)flowElement).isInterrupting()) {
            ExecutableStartEvent executableStartEvent = (ExecutableStartEvent)flowElement;
            this.elementInstanceState.updateInstance(flowScopeElementInstanceKey, flowScopeElementInstance -> flowScopeElementInstance.setInterruptingElementId(executableStartEvent.getEventSubProcess()));
        }
    }

    private boolean isRootStartEvent(long elementInstanceKey) {
        return elementInstanceKey < 0L;
    }
}

