/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.usertask.UserTaskCommandPreconditionChecker;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.List;

public final class UserTaskCompleteProcessor
implements TypedRecordProcessor<UserTaskRecord> {
    private final UserTaskState userTaskState;
    private final ElementInstanceState elementInstanceState;
    private final EventHandle eventHandle;
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final UserTaskCommandPreconditionChecker preconditionChecker;

    public UserTaskCompleteProcessor(ProcessingState state, EventHandle eventHandle, Writers writers) {
        this.userTaskState = state.getUserTaskState();
        this.elementInstanceState = state.getElementInstanceState();
        this.eventHandle = eventHandle;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.preconditionChecker = new UserTaskCommandPreconditionChecker(List.of(UserTaskState.LifecycleState.CREATED), "complete", this.userTaskState);
    }

    @Override
    public void processRecord(TypedRecord<UserTaskRecord> userTaskRecord) {
        this.preconditionChecker.check(userTaskRecord).ifRightOrLeft(ok -> this.completeUserTask(userTaskRecord), violation -> {
            this.rejectionWriter.appendRejection((TypedRecord<? extends RecordValue>)userTaskRecord, (RejectionType)violation.getLeft(), (String)violation.getRight());
            this.responseWriter.writeRejectionOnCommand(userTaskRecord, (RejectionType)violation.getLeft(), (String)violation.getRight());
        });
    }

    private void completeUserTask(TypedRecord<UserTaskRecord> userTaskRecord) {
        long userTaskKey = userTaskRecord.getKey();
        UserTaskRecord persistedUserTask = this.userTaskState.getUserTask(userTaskKey, userTaskRecord.getAuthorizations());
        persistedUserTask.setVariables(((UserTaskRecord)userTaskRecord.getValue()).getVariablesBuffer());
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.COMPLETING, (RecordValue)persistedUserTask);
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.COMPLETED, (RecordValue)persistedUserTask);
        this.completeElementInstance(persistedUserTask);
        this.responseWriter.writeEventOnCommand(userTaskKey, (Intent)UserTaskIntent.COMPLETED, (UnpackedObject)persistedUserTask, userTaskRecord);
    }

    private void completeElementInstance(UserTaskRecord userTaskRecord) {
        long scopeKey;
        ElementInstance scopeInstance;
        long userTaskElementInstanceKey = userTaskRecord.getElementInstanceKey();
        ElementInstance userTaskElementInstance = this.elementInstanceState.getInstance(userTaskElementInstanceKey);
        if (userTaskElementInstance != null && (scopeInstance = this.elementInstanceState.getInstance(scopeKey = userTaskElementInstance.getValue().getFlowScopeKey())) != null && scopeInstance.isActive()) {
            this.eventHandle.triggeringProcessEvent(userTaskRecord);
            this.commandWriter.appendFollowUpCommand(userTaskElementInstanceKey, (Intent)ProcessInstanceIntent.COMPLETE_ELEMENT, (RecordValue)userTaskElementInstance.getValue());
        }
    }
}

