/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.List;

public class UserTaskCommandPreconditionChecker {
    private static final String NO_USER_TASK_FOUND_MESSAGE = "Expected to %s user task with key '%d', but no such user task was found";
    private static final String INVALID_USER_TASK_STATE_MESSAGE = "Expected to %s user task with key '%d', but it is in state '%s'";
    private static final String INVALID_USER_TASK_ASSIGNEE_MESSAGE = "Expected to %s user task with key '%d', but it has already been assigned";
    private static final String INVALID_USER_TASK_EMPTY_ASSIGNEE_MESSAGE = "Expected to %s user task with key '%d', but provided assignee is empty";
    private static final String CLAIM_INTENT = "claim";
    private final List<UserTaskState.LifecycleState> validLifecycleStates;
    private final String intent;
    private final UserTaskState userTaskState;

    public UserTaskCommandPreconditionChecker(List<UserTaskState.LifecycleState> validLifecycleStates, String intent, UserTaskState userTaskState) {
        this.validLifecycleStates = validLifecycleStates;
        this.intent = intent;
        this.userTaskState = userTaskState;
    }

    protected Either<Tuple<RejectionType, String>, UserTaskRecord> check(TypedRecord<UserTaskRecord> command) {
        Either<Tuple<RejectionType, String>, UserTaskRecord> checkResult;
        long userTaskKey = command.getKey();
        UserTaskRecord persistedRecord = this.userTaskState.getUserTask(userTaskKey, command.getAuthorizations());
        if (persistedRecord == null) {
            return Either.left((Object)Tuple.of((Object)RejectionType.NOT_FOUND, (Object)String.format(NO_USER_TASK_FOUND_MESSAGE, this.intent, userTaskKey)));
        }
        UserTaskState.LifecycleState lifecycleState = this.userTaskState.getLifecycleState(userTaskKey);
        if (!this.validLifecycleStates.contains((Object)lifecycleState)) {
            return Either.left((Object)Tuple.of((Object)RejectionType.INVALID_STATE, (Object)String.format(INVALID_USER_TASK_STATE_MESSAGE, new Object[]{this.intent, userTaskKey, lifecycleState})));
        }
        if (CLAIM_INTENT.equals(this.intent) && (checkResult = this.checkClaim(command, persistedRecord)).isLeft()) {
            return checkResult;
        }
        return Either.right((Object)persistedRecord);
    }

    private Either<Tuple<RejectionType, String>, UserTaskRecord> checkClaim(TypedRecord<UserTaskRecord> command, UserTaskRecord persistedRecord) {
        boolean canClaim;
        long userTaskKey = command.getKey();
        String assignee = ((UserTaskRecord)command.getValue()).getAssignee();
        if (assignee.isBlank()) {
            return Either.left((Object)Tuple.of((Object)RejectionType.INVALID_STATE, (Object)String.format(INVALID_USER_TASK_EMPTY_ASSIGNEE_MESSAGE, this.intent, userTaskKey)));
        }
        String currentAssignee = persistedRecord.getAssignee();
        boolean bl = canClaim = currentAssignee.isBlank() || currentAssignee.equals(assignee);
        if (!canClaim) {
            return Either.left((Object)Tuple.of((Object)RejectionType.INVALID_STATE, (Object)String.format(INVALID_USER_TASK_ASSIGNEE_MESSAGE, this.intent, userTaskKey)));
        }
        return Either.right((Object)persistedRecord);
    }
}

