/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.inspections;

import io.camunda.zeebe.process.test.filters.ProcessEventRecordStreamFilter;
import io.camunda.zeebe.process.test.inspections.model.InspectedProcessInstance;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProcessEventInspections {
    private final ProcessEventRecordStreamFilter filter;

    public ProcessEventInspections(ProcessEventRecordStreamFilter filter) {
        this.filter = filter;
    }

    public ProcessEventInspections triggeredByTimer(String timerId) {
        return new ProcessEventInspections(this.filter.withIntent(ProcessEventIntent.TRIGGERED).withTargetElementId(timerId));
    }

    public ProcessEventInspections withProcessDefinitionKey(long processDefinitionKey) {
        return new ProcessEventInspections(this.filter.withProcessDefinitionKey(processDefinitionKey));
    }

    public Optional<InspectedProcessInstance> findFirstProcessInstance() {
        return this.findProcessInstance(0);
    }

    public Optional<InspectedProcessInstance> findLastProcessInstance() {
        List<Long> processInstanceKeys = this.getProcessInstanceKeys();
        return this.findProcessInstance(processInstanceKeys, processInstanceKeys.size() - 1);
    }

    public Optional<InspectedProcessInstance> findProcessInstance(int index) {
        List<Long> processInstanceKeys = this.getProcessInstanceKeys();
        return this.findProcessInstance(processInstanceKeys, index);
    }

    private Optional<InspectedProcessInstance> findProcessInstance(List<Long> keys, int index) {
        try {
            long processInstanceKey = keys.get(index);
            return Optional.of(new InspectedProcessInstance(processInstanceKey));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    private List<Long> getProcessInstanceKeys() {
        return this.filter.stream().map(record -> ((ProcessEventRecordValue)record.getValue()).getProcessInstanceKey()).filter(record -> record != -1L).collect(Collectors.toList());
    }
}

