/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.OwnerTypeEnum;
import io.camunda.zeebe.client.protocol.rest.PermissionTypeEnum;
import io.camunda.zeebe.client.protocol.rest.ResourceTypeEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"ownerId", "ownerType", "resourceId", "resourceType", "permissionTypes"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthorizationRequest {
    public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
    @Nonnull
    private String ownerId;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    @Nonnull
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
    @Nonnull
    private String resourceId;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    @Nonnull
    private ResourceTypeEnum resourceType;
    public static final String JSON_PROPERTY_PERMISSION_TYPES = "permissionTypes";
    @Nonnull
    private List<PermissionTypeEnum> permissionTypes = new ArrayList<PermissionTypeEnum>();

    public AuthorizationRequest ownerId(@Nonnull String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerId(@Nonnull String ownerId) {
        this.ownerId = ownerId;
    }

    public AuthorizationRequest ownerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public AuthorizationRequest resourceId(@Nonnull String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="resourceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resourceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceId(@Nonnull String resourceId) {
        this.resourceId = resourceId;
    }

    public AuthorizationRequest resourceType(@Nonnull ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceType(@Nonnull ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationRequest permissionTypes(@Nonnull List<PermissionTypeEnum> permissionTypes) {
        this.permissionTypes = permissionTypes;
        return this;
    }

    public AuthorizationRequest addPermissionTypesItem(PermissionTypeEnum permissionTypesItem) {
        if (this.permissionTypes == null) {
            this.permissionTypes = new ArrayList<PermissionTypeEnum>();
        }
        this.permissionTypes.add(permissionTypesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="permissionTypes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PermissionTypeEnum> getPermissionTypes() {
        return this.permissionTypes;
    }

    @JsonProperty(value="permissionTypes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPermissionTypes(@Nonnull List<PermissionTypeEnum> permissionTypes) {
        this.permissionTypes = permissionTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)o;
        return Objects.equals(this.ownerId, authorizationRequest.ownerId) && Objects.equals((Object)this.ownerType, (Object)authorizationRequest.ownerType) && Objects.equals(this.resourceId, authorizationRequest.resourceId) && Objects.equals((Object)this.resourceType, (Object)authorizationRequest.resourceType) && Objects.equals(this.permissionTypes, authorizationRequest.permissionTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ownerId, this.ownerType, this.resourceId, this.resourceType, this.permissionTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationRequest {\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    permissionTypes: ").append(this.toIndentedString(this.permissionTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOwnerId() != null) {
            try {
                joiner.add(String.format("%sownerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOwnerId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOwnerType() != null) {
            try {
                joiner.add(String.format("%sownerType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOwnerType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceId() != null) {
            try {
                joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceType() != null) {
            try {
                joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPermissionTypes() != null) {
            for (int i = 0; i < this.getPermissionTypes().size(); ++i) {
                if (this.getPermissionTypes().get(i) == null) continue;
                try {
                    joiner.add(String.format("%spermissionTypes%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getPermissionTypes().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

