/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

@Deprecated
public class CircularBufferInputStream
extends InputStream {
    private final byte[] buffer;
    private final int capacity;
    private int readPos = 0;
    private int writePos = 0;
    private int availableData = 0;
    private boolean endOfStream = false;
    private IOException exception = null;
    private CapacityCallback capacityCallback;

    public CircularBufferInputStream(int capacity) {
        this.capacity = capacity;
        this.buffer = new byte[capacity];
    }

    public synchronized void setCapacityCallback(CapacityCallback capacityCallback) {
        this.capacityCallback = capacityCallback;
    }

    public synchronized void write(ByteBuffer data) throws IOException {
        int availableSpace;
        if (this.exception != null) {
            throw this.exception;
        }
        int dataSize = data.remaining();
        if (dataSize > (availableSpace = this.getAvailableSpace())) {
            throw new IOException("Buffer is full");
        }
        int firstCopyLength = Math.min(dataSize, this.capacity - this.writePos);
        data.get(this.buffer, this.writePos, firstCopyLength);
        this.writePos = (this.writePos + firstCopyLength) % this.capacity;
        int remaining = dataSize - firstCopyLength;
        if (remaining > 0) {
            data.get(this.buffer, this.writePos, remaining);
            this.writePos = (this.writePos + remaining) % this.capacity;
        }
        this.availableData += dataSize;
        this.notifyAll();
    }

    public synchronized void endOfStream() {
        this.endOfStream = true;
        this.notifyAll();
    }

    public synchronized void signalError(IOException e) {
        this.exception = e;
        this.notifyAll();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.canConsumeData()) {
            return -1;
        }
        int b = this.buffer[this.readPos] & 0xFF;
        this.readPos = (this.readPos + 1) % this.capacity;
        --this.availableData;
        this.notifyAll();
        if (this.capacityCallback != null) {
            this.capacityCallback.onCapacityAvailable(1);
        }
        return b;
    }

    @Override
    public synchronized int read(@Nonnull byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.canConsumeData()) {
            return -1;
        }
        int bytesRead = 0;
        int bytesToRead = Math.min(len, this.availableData);
        int firstCopyLength = Math.min(bytesToRead, this.capacity - this.readPos);
        System.arraycopy(this.buffer, this.readPos, b, off, firstCopyLength);
        this.readPos = (this.readPos + firstCopyLength) % this.capacity;
        bytesRead += firstCopyLength;
        this.availableData -= firstCopyLength;
        int remaining = bytesToRead - firstCopyLength;
        if (remaining > 0) {
            System.arraycopy(this.buffer, this.readPos, b, off + firstCopyLength, remaining);
            this.readPos = (this.readPos + remaining) % this.capacity;
            bytesRead += remaining;
            this.availableData -= remaining;
        }
        this.notifyAll();
        if (this.capacityCallback != null) {
            this.capacityCallback.onCapacityAvailable(bytesRead);
        }
        return bytesRead;
    }

    private boolean canConsumeData() throws IOException {
        while (this.availableData == 0 && this.exception == null && !this.endOfStream) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while reading", e);
            }
        }
        if (this.exception != null) {
            IOException ex = this.exception;
            this.exception = null;
            throw ex;
        }
        return this.availableData == 0;
    }

    public synchronized int getAvailableSpace() {
        return this.capacity - this.availableData;
    }

    public static interface CapacityCallback {
        public void onCapacityAvailable(int var1);
    }
}

