/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.CancelProcessInstanceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.CancelProcessInstanceResponseImpl;
import io.camunda.zeebe.client.protocol.rest.CancelProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CancelProcessInstanceCommandImpl
implements CancelProcessInstanceCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CancelProcessInstanceRequest.Builder builder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private boolean useRest;
    private final long processInstanceKey;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;
    private final CancelProcessInstanceRequest httpRequestObject;
    private final HttpClient httpClient;

    public CancelProcessInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, long processInstanceKey, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, ZeebeClientConfiguration config, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.CancelProcessInstanceRequest.newBuilder();
        this.builder.setProcessInstanceKey(processInstanceKey);
        this.useRest = config.preferRestOverGrpc();
        this.processInstanceKey = processInstanceKey;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new CancelProcessInstanceRequest();
        this.httpClient = httpClient;
        this.requestTimeout(this.requestTimeout);
    }

    @Override
    public FinalCommandStep<CancelProcessInstanceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<CancelProcessInstanceResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<CancelProcessInstanceResponse> sendRestRequest() {
        HttpZeebeFuture<CancelProcessInstanceResponse> result = new HttpZeebeFuture<CancelProcessInstanceResponse>();
        this.httpClient.post("/process-instances/" + this.processInstanceKey + "/cancellation", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    public ZeebeFuture<CancelProcessInstanceResponse> sendGrpcRequest() {
        GatewayOuterClass.CancelProcessInstanceRequest request = this.builder.build();
        RetriableClientFutureImpl<CancelProcessInstanceResponse, GatewayOuterClass.CancelProcessInstanceResponse> future = new RetriableClientFutureImpl<CancelProcessInstanceResponse, GatewayOuterClass.CancelProcessInstanceResponse>(CancelProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.CancelProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).cancelProcessInstance(request, future);
    }

    @Override
    public CancelProcessInstanceCommandStep1 operationReference(long operationReference) {
        this.builder.setOperationReference(operationReference);
        return this;
    }

    @Override
    public CancelProcessInstanceCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public CancelProcessInstanceCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

