/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.BrokerInfo;
import io.camunda.zeebe.client.api.response.Topology;
import io.camunda.zeebe.client.impl.response.BrokerInfoImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.List;
import java.util.stream.Collectors;

public final class TopologyImpl
implements Topology {
    private final List<BrokerInfo> brokers;
    private final int clusterSize;
    private final int partitionsCount;
    private final int replicationFactor;
    private final String gatewayVersion;

    public TopologyImpl(GatewayOuterClass.TopologyResponse response) {
        this.brokers = response.getBrokersList().stream().map(BrokerInfoImpl::new).collect(Collectors.toList());
        this.clusterSize = response.getClusterSize();
        this.partitionsCount = response.getPartitionsCount();
        this.replicationFactor = response.getReplicationFactor();
        this.gatewayVersion = response.getGatewayVersion();
    }

    @Override
    public List<BrokerInfo> getBrokers() {
        return this.brokers;
    }

    @Override
    public int getClusterSize() {
        return this.clusterSize;
    }

    @Override
    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public String getGatewayVersion() {
        return this.gatewayVersion;
    }

    public String toString() {
        return "TopologyImpl{brokers=" + this.brokers + ", clusterSize=" + this.clusterSize + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + ", gatewayVersion=" + this.gatewayVersion + '}';
    }
}

