/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.sso;

import com.auth0.jwt.interfaces.Claim;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.webapp.graphql.entity.C8AppLink;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.security.sso.TokenAuthentication;
import io.camunda.tasklist.webapp.security.sso.model.C8ConsoleService;
import io.camunda.tasklist.webapp.security.sso.model.ClusterMetadata;
import jakarta.json.Json;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"sso-auth"})
public class SSOUserReader
implements UserReader {
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private C8ConsoleService c8ConsoleService;
    @Autowired
    private IdentityAuthorizationService identityAuthorizationService;

    @Override
    public Optional<UserDTO> getCurrentUserBy(Authentication authentication) {
        if (authentication instanceof TokenAuthentication) {
            TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
            Map<String, Claim> claims = tokenAuthentication.getClaims();
            String name = "No name";
            if (claims.containsKey(this.tasklistProperties.getAuth0().getNameKey())) {
                name = claims.get(this.tasklistProperties.getAuth0().getNameKey()).asString();
            }
            String email = claims.get(this.tasklistProperties.getAuth0().getEmailKey()).asString();
            ClusterMetadata clusterMetadata = this.c8ConsoleService.getClusterMetadata();
            List<C8AppLink> c8Links = List.of();
            if (clusterMetadata != null) {
                c8Links = clusterMetadata.getUrlsAsC8AppLinks();
            }
            return Optional.of(new UserDTO().setUserId(email).setDisplayName(name).setApiUser(false).setGroups(this.identityAuthorizationService.getUserGroups()).setPermissions(tokenAuthentication.getPermissions()).setRoles(tokenAuthentication.getRoles(this.tasklistProperties.getAuth0().getOrganizationsKey())).setSalesPlanType(tokenAuthentication.getSalesPlanType()).setC8Links(c8Links));
        }
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthentication = (JwtAuthenticationToken)authentication;
            String name = jwtAuthentication.getName() == null ? "No name" : jwtAuthentication.getName();
            return Optional.of(new UserDTO().setUserId(name).setDisplayName(name).setApiUser(true).setPermissions(List.of(Permission.WRITE)));
        }
        return Optional.empty();
    }

    @Override
    public String getCurrentOrganizationId() {
        return this.tasklistProperties.getAuth0().getOrganization();
    }

    @Override
    public List<UserDTO> getUsersByUsernames(List<String> usernames) {
        return CollectionUtil.map(usernames, name -> new UserDTO().setDisplayName((String)name).setUserId((String)name).setApiUser(false));
    }

    @Override
    public Optional<String> getUserToken(Authentication authentication) {
        if (authentication instanceof TokenAuthentication) {
            return Optional.of(Json.createValue((String)((TokenAuthentication)authentication).getAccessToken()).toString());
        }
        throw new UnsupportedOperationException("Not supported for token class: " + authentication.getClass().getName());
    }
}

