/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.CsrfRequireMatcher;
import io.camunda.tasklist.webapp.security.TasklistProfileService;
import io.camunda.tasklist.webapp.security.TasklistURIs;
import jakarta.json.Json;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hc.core5.http.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.logging.LoggersEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class BaseWebConfigurer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected TasklistProperties tasklistProperties;
    @Autowired
    TasklistProfileService errorMessageService;
    final CookieCsrfTokenRepository cookieCsrfTokenRepository = new CookieCsrfTokenRepository();
    @Autowired
    private TasklistProfileService profileService;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, HandlerMappingIntrospector introspector) throws Exception {
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        this.applySecurityHeadersSettings(http);
        this.applySecurityFilterSettings(http, introspector);
        this.applyAuthenticationSettings(authenticationManagerBuilder);
        this.applyOAuth2Settings(http);
        return (SecurityFilterChain)http.build();
    }

    protected abstract void applyOAuth2Settings(HttpSecurity var1) throws Exception;

    protected void applySecurityHeadersSettings(HttpSecurity http) throws Exception {
        http.headers().contentSecurityPolicy(this.tasklistProperties.getSecurityProperties().getContentSecurityPolicy());
    }

    protected void applySecurityFilterSettings(HttpSecurity http, HandlerMappingIntrospector introspector) throws Exception {
        this.defaultFilterSettings(http, introspector);
    }

    private void defaultFilterSettings(HttpSecurity http, HandlerMappingIntrospector introspector) throws Exception {
        if (this.tasklistProperties.isCsrfPreventionEnabled()) {
            this.logger.info("CSRF Protection Enabled");
            this.configureCSRF(http);
        } else {
            http.csrf(csrf -> csrf.disable());
        }
        http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.requestMatchers(TasklistURIs.getAuthWhitelist(introspector))).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/graphql"), AntPathRequestMatcher.antMatcher((String)"/v*/**"), AntPathRequestMatcher.antMatcher((String)"/error")})).authenticated().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/login")})).authenticated()).formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)login.loginProcessingUrl("/api/login")).successHandler(this::successHandler)).failureHandler(this::failureHandler)).permitAll()).logout(logout -> logout.logoutUrl("/api/logout").logoutSuccessHandler(this::logoutSuccessHandler).permitAll().invalidateHttpSession(true).deleteCookies(new String[]{"TASKLIST-SESSION", "X-CSRF-TOKEN"})).exceptionHandling(handling -> handling.authenticationEntryPoint(this::failureHandler));
    }

    protected void applyAuthenticationSettings(AuthenticationManagerBuilder builder) throws Exception {
    }

    private void logoutSuccessHandler(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    private void failureHandler(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) throws IOException {
        request.getSession().invalidate();
        BaseWebConfigurer.sendJSONErrorMessage(response, this.profileService.getMessageByProfileFor((Exception)ex));
    }

    private void csrfHandler(HttpServletRequest request, HttpServletResponse response, AccessDeniedException ex) throws IOException {
        response.setStatus(403);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        String jsonErrorResponse = "{\"error\": \"Access denied due to invalid CSRF token.\"}";
        response.getWriter().write("{\"error\": \"Access denied due to invalid CSRF token.\"}");
    }

    public static void sendJSONErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.reset();
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        String jsonResponse = Json.createObjectBuilder().add("message", message).build().toString();
        writer.append(jsonResponse);
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
    }

    private void successHandler(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.addCSRFTokenWhenAvailable(request, response).setStatus(HttpStatus.NO_CONTENT.value());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void configureCSRF(HttpSecurity http) throws Exception {
        this.cookieCsrfTokenRepository.setHeaderName("X-CSRF-TOKEN");
        this.cookieCsrfTokenRepository.setCookieCustomizer(c -> c.httpOnly(true));
        this.cookieCsrfTokenRepository.setCookieName("X-CSRF-TOKEN");
        http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)this.cookieCsrfTokenRepository).requireCsrfProtectionMatcher((RequestMatcher)new CsrfRequireMatcher()).ignoringRequestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{LoggersEndpoint.class})})).addFilterAfter((Filter)this.getCSRFHeaderFilter(), CsrfFilter.class).exceptionHandling(handling -> handling.accessDeniedHandler(this::csrfHandler));
    }

    protected OncePerRequestFilter getCSRFHeaderFilter() {
        return new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)BaseWebConfigurer.this.addCSRFTokenWhenAvailable(request, response));
            }
        };
    }

    protected HttpServletResponse addCSRFTokenWhenAvailable(HttpServletRequest request, HttpServletResponse response) {
        CsrfToken token;
        if (this.shouldAddCSRF(request) && (token = (CsrfToken)request.getAttribute(CsrfToken.class.getName())) != null) {
            response.setHeader("X-CSRF-TOKEN", token.getToken());
        }
        return response;
    }

    boolean shouldAddCSRF(HttpServletRequest request) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String path = request.getRequestURI();
        String method = request.getMethod();
        return auth != null && auth.isAuthenticated() && (path == null || !path.contains("/api/logout")) && ("GET".equalsIgnoreCase(method) || path != null && path.contains("/api/login"));
    }
}

