/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql.entity;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import io.camunda.tasklist.webapp.graphql.entity.C8AppLink;
import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.tenant.TasklistTenant;
import java.util.List;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class UserDTO {
    @GraphQLField
    @GraphQLNonNull
    private String userId;
    @GraphQLField
    private String displayName;
    private boolean apiUser;
    @GraphQLField
    private List<Permission> permissions;
    @GraphQLField
    private List<String> roles;
    @GraphQLField
    private String salesPlanType;
    @GraphQLField
    private List<C8AppLink> c8Links = List.of();
    private List<TasklistTenant> tenants = List.of();
    private List<String> groups = List.of();

    public String getUserId() {
        return this.userId;
    }

    public UserDTO setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getDisplayName() {
        if (!StringUtils.hasText((String)this.displayName)) {
            return this.userId;
        }
        return this.displayName;
    }

    public UserDTO setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean isApiUser() {
        return this.apiUser;
    }

    public UserDTO setApiUser(boolean apiUser) {
        this.apiUser = apiUser;
        return this;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public UserDTO setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public UserDTO setRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public UserDTO setSalesPlanType(String salesPlanType) {
        this.salesPlanType = salesPlanType;
        return this;
    }

    public String getSalesPlanType() {
        return this.salesPlanType;
    }

    public List<C8AppLink> getC8Links() {
        return this.c8Links;
    }

    public UserDTO setC8Links(List<C8AppLink> c8Links) {
        if (c8Links != null) {
            this.c8Links = c8Links;
        }
        return this;
    }

    public List<TasklistTenant> getTenants() {
        return this.tenants;
    }

    public UserDTO setTenants(List<TasklistTenant> tenants) {
        if (tenants != null) {
            this.tenants = tenants;
        }
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public UserDTO setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDTO userDTO = (UserDTO)o;
        return this.apiUser == userDTO.apiUser && Objects.equals(this.userId, userDTO.userId) && Objects.equals(this.displayName, userDTO.displayName) && Objects.equals(this.permissions, userDTO.permissions) && Objects.equals(this.roles, userDTO.roles) && Objects.equals(this.salesPlanType, userDTO.salesPlanType) && Objects.equals(this.c8Links, userDTO.c8Links) && Objects.equals(this.tenants, userDTO.tenants) && Objects.equals(this.groups, userDTO.groups);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.displayName, this.apiUser, this.permissions, this.roles, this.salesPlanType, this.c8Links, this.tenants, this.groups);
    }

    public String toString() {
        return "UserDTO{userId='" + this.userId + "', displayName='" + this.displayName + "', apiUser=" + this.apiUser + ", permissions=" + String.valueOf(this.permissions) + ", roles=" + String.valueOf(this.roles) + ", salesPlanType='" + this.salesPlanType + "', c8Links=" + String.valueOf(this.c8Links) + ", tenants=" + String.valueOf(this.tenants) + ", groups=" + String.valueOf(this.groups) + "}";
    }
}

