/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.config;

import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class OpenApiConfig {
    public static final String COOKIE_SECURITY_SCHEMA_NAME = "cookie";
    public static final SecurityScheme COOKIE_SECURITY_SCHEMA = new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.COOKIE).name("TASKLIST-SESSION").description("Cookie-based authentication is only available on Self-Managed clusters.");
    public static final String BEARER_SECURITY_SCHEMA_NAME = "bearer-key";
    public static final SecurityScheme BEARER_SECURITY_SCHEMA = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT");

    @Profile(value={"dev", "preview"})
    @Bean
    public GroupedOpenApi internalApiV1() {
        return this.versionedInternalApi("v1");
    }

    @Profile(value={"dev", "preview"})
    @Bean
    public GroupedOpenApi externalApiV1() {
        return this.versionedExternalApi("v1");
    }

    @Bean
    public GroupedOpenApi publicApiV1() {
        return this.versionedPublicApi("v1");
    }

    private GroupedOpenApi versionedInternalApi(String version) {
        return GroupedOpenApi.builder().group("internal-api").addOpenApiCustomizer(openApi -> {
            openApi.info(new Info().title("Tasklist webapp Internal API").description("<b>NOTE:</b> For internal use only.<br>Please take into account that this is an <b>internal API</b> and it may be subject to changes in the future without guaranteeing backward compatibility with previous versions.").contact(new Contact().url("https://www.camunda.com")).license(new License().name("License").url("https://docs.camunda.io/docs/reference/licenses/"))).getComponents().addSecuritySchemes(COOKIE_SECURITY_SCHEMA_NAME, COOKIE_SECURITY_SCHEMA).addSecuritySchemes(BEARER_SECURITY_SCHEMA_NAME, BEARER_SECURITY_SCHEMA);
            openApi.addSecurityItem(new SecurityRequirement().addList(COOKIE_SECURITY_SCHEMA_NAME).addList(BEARER_SECURITY_SCHEMA_NAME));
        }).pathsToMatch(new String[]{String.format("/%s/internal/**", version)}).build();
    }

    private GroupedOpenApi versionedExternalApi(String version) {
        return GroupedOpenApi.builder().group("external-api").addOpenApiCustomizer(openApi -> {
            openApi.info(new Info().title("Tasklist webapp External API").description("<b>NOTE:</b> For public use.<br>This API is exposed publicly but should only be used by internal apps.").contact(new Contact().url("https://www.camunda.com")).license(new License().name("License").url("https://docs.camunda.io/docs/reference/licenses/"))).getComponents().addSecuritySchemes(COOKIE_SECURITY_SCHEMA_NAME, COOKIE_SECURITY_SCHEMA).addSecuritySchemes(BEARER_SECURITY_SCHEMA_NAME, BEARER_SECURITY_SCHEMA);
            openApi.addSecurityItem(new SecurityRequirement().addList(COOKIE_SECURITY_SCHEMA_NAME).addList(BEARER_SECURITY_SCHEMA_NAME));
        }).pathsToMatch(new String[]{String.format("/%s/external/**", version)}).build();
    }

    private GroupedOpenApi versionedPublicApi(String version) {
        return GroupedOpenApi.builder().group(version).addOpenApiCustomizer(openApi -> {
            openApi.info(new Info().title("Tasklist REST API").description("Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.").version("v1").contact(new Contact().url("https://www.camunda.com")).license(new License().name("License").url("https://docs.camunda.io/docs/reference/licenses/"))).getComponents().addSecuritySchemes(COOKIE_SECURITY_SCHEMA_NAME, COOKIE_SECURITY_SCHEMA).addSecuritySchemes(BEARER_SECURITY_SCHEMA_NAME, BEARER_SECURITY_SCHEMA);
            openApi.addSecurityItem(new SecurityRequirement().addList(COOKIE_SECURITY_SCHEMA_NAME).addList(BEARER_SECURITY_SCHEMA_NAME));
        }).pathsToMatch(new String[]{String.format("/%s/**", version)}).pathsToExclude(new String[]{String.format("/%s/internal/**", version), String.format("/%s/external/**", version)}).build();
    }

    @Bean(value={"springdocObjectMapperProvider"})
    public ObjectMapperProvider objectMapperProvider(SpringDocConfigProperties springDocConfigProperties) {
        return new ObjectMapperProvider(springDocConfigProperties);
    }
}

