/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import io.camunda.tasklist.util.ThreadUtil;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZeebeTestUtil {
    public static final Logger ALL_EVENTS_LOGGER = LoggerFactory.getLogger((String)"io.camunda.tasklist.ALL_EVENTS");
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeTestUtil.class);

    public static String deployProcess(ZeebeClient client, String ... classpathResources) {
        return ZeebeTestUtil.deployProcess("<default>", client, classpathResources);
    }

    public static String deployProcess(String tenantId, ZeebeClient client, String ... classpathResources) {
        if (classpathResources.length == 0) {
            return null;
        }
        DeployResourceCommandStep1 deployProcessCommandStep1 = client.newDeployResourceCommand();
        for (String classpathResource : classpathResources) {
            deployProcessCommandStep1 = (DeployResourceCommandStep1)deployProcessCommandStep1.addResourceFromClasspath(classpathResource).tenantId(tenantId);
        }
        DeploymentEvent deploymentEvent = (DeploymentEvent)((DeployResourceCommandStep1.DeployResourceCommandStep2)deployProcessCommandStep1).send().join();
        LOGGER.debug("Deployment of resource [{}] was performed", (Object[])classpathResources);
        return String.valueOf(((Process)deploymentEvent.getProcesses().get(classpathResources.length - 1)).getProcessDefinitionKey());
    }

    public static String deployProcess(ZeebeClient client, BpmnModelInstance processModel, String resourceName) {
        return ZeebeTestUtil.deployProcess("<default>", client, processModel, resourceName);
    }

    public static String deployProcess(ZeebeClient client, BpmnModelInstance processModel, String resourceName, String tenantId) {
        return ZeebeTestUtil.deployProcess(tenantId, client, processModel, resourceName);
    }

    public static String deployProcess(String tenantId, ZeebeClient client, BpmnModelInstance processModel, String resourceName) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployProcessCommandStep1 = (DeployResourceCommandStep1.DeployResourceCommandStep2)client.newDeployResourceCommand().addProcessModel(processModel, resourceName).tenantId(tenantId);
        DeploymentEvent deploymentEvent = (DeploymentEvent)deployProcessCommandStep1.send().join();
        LOGGER.debug("Deployment of resource [{}] was performed", (Object)resourceName);
        return String.valueOf(((Process)deploymentEvent.getProcesses().get(0)).getProcessDefinitionKey());
    }

    public static void deleteResource(ZeebeClient client, long resourceKey) {
        client.newDeleteResourceCommand(resourceKey).send().join();
        LOGGER.debug("Deletion of resource [{}] was performed", (Object)resourceKey);
    }

    public static String startProcessInstance(ZeebeClient client, String bpmnProcessId, String payload) {
        return ZeebeTestUtil.startProcessInstance("<default>", client, bpmnProcessId, payload);
    }

    public static String startProcessInstance(String tenantId, ZeebeClient client, String bpmnProcessId, String payload) {
        ProcessInstanceEvent processInstanceEvent;
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3 = (CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3)client.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion().tenantId(tenantId);
        if (payload != null) {
            createProcessInstanceCommandStep3.variables(payload);
        }
        try {
            processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
            LOGGER.debug("Process instance created for process [{}]", (Object)bpmnProcessId);
        }
        catch (ClientException ex) {
            ThreadUtil.sleepFor(300L);
            processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
            LOGGER.debug("Process instance created for process [{}]", (Object)bpmnProcessId);
        }
        return String.valueOf(processInstanceEvent.getProcessInstanceKey());
    }

    public static void cancelProcessInstance(ZeebeClient client, long processInstanceKey) {
        client.newCancelInstanceCommand(processInstanceKey).send().join();
    }

    public static void completeTask(ZeebeClient client, String jobType, String workerName, String payload) {
        ZeebeTestUtil.completeTask(client, jobType, workerName, payload, 1);
    }

    public static void completeTask(ZeebeClient client, String jobType, String workerName, String payload, int count) {
        ZeebeTestUtil.handleTasks(client, jobType, workerName, count, (jobClient, job) -> {
            CompleteJobCommandStep1 command = jobClient.newCompleteCommand(job.getKey());
            if (payload != null) {
                command.variables(payload);
            }
            command.send().join();
        });
    }

    public static Long failTask(ZeebeClient client, String jobType, String workerName, int numberOfFailures, String errorMessage) {
        return ZeebeTestUtil.handleTasks(client, jobType, workerName, numberOfFailures, (jobClient, job) -> {
            FailJobCommandStep1.FailJobCommandStep2 failCommand = jobClient.newFailCommand(job.getKey()).retries(job.getRetries() - 1);
            if (errorMessage != null) {
                failCommand.errorMessage(errorMessage);
            }
            failCommand.send().join();
        }).get(0);
    }

    public static Long failTaskWithRetries(ZeebeClient client, String jobType, String workerName, int numberOfJobs, int numberOfRetries, String errorMessage) {
        return ZeebeTestUtil.handleTasks(client, jobType, workerName, numberOfJobs, (jobClient, job) -> {
            FailJobCommandStep1.FailJobCommandStep2 failCommand = jobClient.newFailCommand(job.getKey()).retries(numberOfRetries);
            if (errorMessage != null) {
                failCommand.errorMessage(errorMessage);
            }
            failCommand.send().join();
        }).get(0);
    }

    public static Long throwErrorInTask(ZeebeClient client, String jobType, String workerName, int numberOfFailures, String errorCode, String errorMessage) {
        return ZeebeTestUtil.handleTasks(client, jobType, workerName, numberOfFailures, (jobClient, job) -> jobClient.newThrowErrorCommand(job.getKey()).errorCode(errorCode).errorMessage(errorMessage).send().join()).get(0);
    }

    private static List<Long> handleTasks(ZeebeClient client, String jobType, String workerName, int jobCount, BiConsumer<JobClient, ActivatedJob> jobHandler) {
        ArrayList<Long> jobKeys = new ArrayList<Long>();
        while (jobKeys.size() < jobCount) {
            ((ActivateJobsResponse)client.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(jobCount - jobKeys.size()).workerName(workerName).timeout(Duration.ofSeconds(2L)).send().join()).getJobs().forEach(job -> {
                jobHandler.accept((JobClient)client, (ActivatedJob)job);
                jobKeys.add(job.getKey());
            });
        }
        return jobKeys;
    }

    public static void resolveIncident(ZeebeClient client, Long jobKey, Long incidentKey) {
        client.newUpdateRetriesCommand(jobKey.longValue()).retries(3).send().join();
        client.newResolveIncidentCommand(incidentKey.longValue()).send().join();
    }

    public static void updateVariables(ZeebeClient client, Long scopeKey, String newPayload) {
        client.newSetVariablesCommand(scopeKey.longValue()).variables(newPayload).local(true).send().join();
    }
}

