/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.queries;

import io.camunda.tasklist.entities.TaskImplementation;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.queries.DateFilter;
import io.camunda.tasklist.queries.RangeValueFilter;
import io.camunda.tasklist.queries.TaskByCandidateUserOrGroup;
import io.camunda.tasklist.queries.TaskByVariables;
import io.camunda.tasklist.queries.TaskOrderBy;
import java.util.Arrays;
import java.util.Objects;

public class TaskQuery {
    private TaskState state;
    private Boolean assigned;
    private String assignee;
    private String[] assignees;
    private String taskDefinitionId;
    private String candidateGroup;
    private String[] candidateGroups;
    private String candidateUser;
    private String[] candidateUsers;
    private String processDefinitionId;
    private String processInstanceId;
    private int pageSize;
    private TaskByVariables[] taskVariables;
    private String[] tenantIds;
    private String[] searchAfter;
    private String[] searchAfterOrEqual;
    private String[] searchBefore;
    private String[] searchBeforeOrEqual;
    private DateFilter followUpDate;
    private DateFilter dueDate;
    private TaskOrderBy[] sort;
    private TaskByCandidateUserOrGroup taskByCandidateUserOrGroups;
    private TaskImplementation implementation;
    private RangeValueFilter priority;

    public TaskState getState() {
        return this.state;
    }

    public TaskQuery setState(TaskState state) {
        this.state = state;
        return this;
    }

    public Boolean getAssigned() {
        return this.assigned;
    }

    public TaskQuery setAssigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskQuery setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public TaskQuery setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public TaskQuery setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public TaskQuery setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public TaskQuery setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public TaskQuery setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public TaskByVariables[] getTaskVariables() {
        return this.taskVariables;
    }

    public TaskQuery setTaskVariables(TaskByVariables[] taskVariables) {
        this.taskVariables = taskVariables;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public TaskQuery setTenantIds(String[] tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public TaskQuery setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String[] getSearchAfter() {
        return this.searchAfter;
    }

    public TaskQuery setSearchAfter(String[] searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public String[] getSearchAfterOrEqual() {
        return this.searchAfterOrEqual;
    }

    public TaskQuery setSearchAfterOrEqual(String[] searchAfterOrEqual) {
        this.searchAfterOrEqual = searchAfterOrEqual;
        return this;
    }

    public String[] getSearchBefore() {
        return this.searchBefore;
    }

    public TaskQuery setSearchBefore(String[] searchBefore) {
        this.searchBefore = searchBefore;
        return this;
    }

    public String[] getSearchBeforeOrEqual() {
        return this.searchBeforeOrEqual;
    }

    public TaskQuery setSearchBeforeOrEqual(String[] searchBeforeOrEqual) {
        this.searchBeforeOrEqual = searchBeforeOrEqual;
        return this;
    }

    public DateFilter getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskQuery setFollowUpDate(DateFilter followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public DateFilter getDueDate() {
        return this.dueDate;
    }

    public TaskQuery setDueDate(DateFilter dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskOrderBy[] getSort() {
        return this.sort;
    }

    public TaskQuery setSort(TaskOrderBy[] sort) {
        this.sort = sort;
        return this;
    }

    public String[] getAssignees() {
        return this.assignees;
    }

    public TaskQuery setAssignees(String[] assignees) {
        this.assignees = assignees;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskQuery setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskQuery setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public TaskByCandidateUserOrGroup getTaskByCandidateUserOrGroups() {
        return this.taskByCandidateUserOrGroups;
    }

    public TaskQuery setTaskByCandidateUserOrGroups(TaskByCandidateUserOrGroup taskByCandidateUserOrGroups) {
        this.taskByCandidateUserOrGroups = taskByCandidateUserOrGroups;
        return this;
    }

    public TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskQuery setImplementation(TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public RangeValueFilter getPriority() {
        return this.priority;
    }

    public TaskQuery setPriority(RangeValueFilter priority) {
        this.priority = priority;
        return this;
    }

    public TaskQuery createCopy() {
        return new TaskQuery().setAssigned(this.assigned).setAssignee(this.assignee).setTaskDefinitionId(this.taskDefinitionId).setPageSize(this.pageSize).setSearchAfter(this.searchAfter).setSearchAfterOrEqual(this.searchAfterOrEqual).setSearchBefore(this.searchBefore).setSearchBeforeOrEqual(this.searchBeforeOrEqual).setState(this.state).setTaskVariables(this.taskVariables).setTenantIds(this.tenantIds).setCandidateGroup(this.candidateGroup).setTaskByCandidateUserOrGroups(this.taskByCandidateUserOrGroups).setImplementation(this.implementation).setAssignees(this.assignees).setCandidateGroups(this.candidateGroups).setCandidateUsers(this.candidateUsers).setPriority(this.priority);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.state, this.assigned, this.assignee, this.taskDefinitionId, this.candidateGroup, this.candidateUser, this.processDefinitionId, this.processInstanceId, this.pageSize, this.followUpDate, this.dueDate, this.taskByCandidateUserOrGroups, this.implementation, this.priority});
        result = 31 * result + Arrays.hashCode(this.tenantIds);
        result = 31 * result + Arrays.hashCode(this.assignees);
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        result = 31 * result + Arrays.hashCode(this.taskVariables);
        result = 31 * result + Arrays.hashCode(this.tenantIds);
        result = 31 * result + Arrays.hashCode(this.searchAfter);
        result = 31 * result + Arrays.hashCode(this.searchAfterOrEqual);
        result = 31 * result + Arrays.hashCode(this.searchBefore);
        result = 31 * result + Arrays.hashCode(this.searchBeforeOrEqual);
        result = 31 * result + Arrays.hashCode(this.sort);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQuery taskQuery = (TaskQuery)o;
        return this.pageSize == taskQuery.pageSize && this.state == taskQuery.state && this.implementation == taskQuery.implementation && Objects.equals(this.assigned, taskQuery.assigned) && Objects.equals(this.assignee, taskQuery.assignee) && Arrays.equals(this.assignees, taskQuery.assignees) && Objects.equals(this.taskDefinitionId, taskQuery.taskDefinitionId) && Objects.equals(this.candidateGroup, taskQuery.candidateGroup) && Arrays.equals(this.candidateGroups, taskQuery.candidateGroups) && Objects.equals(this.candidateUser, taskQuery.candidateUser) && Arrays.equals(this.candidateUsers, taskQuery.candidateUsers) && Objects.equals(this.processDefinitionId, taskQuery.processDefinitionId) && Objects.equals(this.processInstanceId, taskQuery.processInstanceId) && Arrays.equals(this.taskVariables, taskQuery.taskVariables) && Arrays.equals(this.tenantIds, taskQuery.tenantIds) && Arrays.equals(this.searchAfter, taskQuery.searchAfter) && Arrays.equals(this.searchAfterOrEqual, taskQuery.searchAfterOrEqual) && Arrays.equals(this.searchBefore, taskQuery.searchBefore) && Arrays.equals(this.searchBeforeOrEqual, taskQuery.searchBeforeOrEqual) && Objects.equals(this.followUpDate, taskQuery.followUpDate) && Objects.equals(this.dueDate, taskQuery.dueDate) && Objects.equals(this.priority, taskQuery.priority) && Objects.equals(this.taskByCandidateUserOrGroups, taskQuery.taskByCandidateUserOrGroups) && Arrays.equals(this.sort, taskQuery.sort);
    }

    public String toString() {
        return "TaskQuery{state=" + String.valueOf((Object)this.state) + ", assigned=" + this.assigned + ", assignee='" + this.assignee + "', assignees=" + Arrays.toString(this.assignees) + ", taskDefinitionId='" + this.taskDefinitionId + "', candidateGroup='" + this.candidateGroup + "', candidateGroups=" + Arrays.toString(this.candidateGroups) + ", candidateUser='" + this.candidateUser + "', candidateUsers=" + Arrays.toString(this.candidateUsers) + ", processDefinitionId='" + this.processDefinitionId + "', processInstanceId='" + this.processInstanceId + "', pageSize=" + this.pageSize + ", taskVariables=" + Arrays.toString(this.taskVariables) + ", tenantIds=" + Arrays.toString(this.tenantIds) + ", searchAfter=" + Arrays.toString(this.searchAfter) + ", searchAfterOrEqual=" + Arrays.toString(this.searchAfterOrEqual) + ", searchBefore=" + Arrays.toString(this.searchBefore) + ", searchBeforeOrEqual=" + Arrays.toString(this.searchBeforeOrEqual) + ", followUpDate=" + String.valueOf(this.followUpDate) + ", dueDate=" + String.valueOf(this.dueDate) + ", sort=" + Arrays.toString(this.sort) + ", taskByCandidateUserOrGroups=" + String.valueOf(this.taskByCandidateUserOrGroups) + ", implementation=" + String.valueOf((Object)this.implementation) + ", priority=" + String.valueOf(this.priority) + "}";
    }
}

