/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.queries;

import graphql.annotations.annotationTypes.GraphQLConstructor;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import io.camunda.tasklist.queries.Sort;
import io.camunda.tasklist.queries.TaskSortFields;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.StringJoiner;

@Schema(description="Sort results by a specific field.")
public class TaskOrderBy {
    @GraphQLField
    @GraphQLNonNull
    private TaskSortFields field;
    @Schema(description="* `ASC`: Ascending<br>* `DESC`: Descending")
    @GraphQLField
    @GraphQLNonNull
    private Sort order;

    @GraphQLConstructor
    public TaskOrderBy(TaskSortFields field, Sort order) {
        this.field = field;
        this.order = order;
    }

    public TaskOrderBy() {
    }

    public TaskSortFields getField() {
        return this.field;
    }

    public TaskOrderBy setField(TaskSortFields field) {
        this.field = field;
        return this;
    }

    public Sort getOrder() {
        return this.order;
    }

    public TaskOrderBy setOrder(Sort order) {
        this.order = order;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskOrderBy that = (TaskOrderBy)o;
        return this.field == that.field && this.order == that.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.order});
    }

    public String toString() {
        return new StringJoiner(", ", TaskOrderBy.class.getSimpleName() + "[", "]").add("field=" + String.valueOf((Object)this.field)).add("order=" + String.valueOf((Object)this.order)).toString();
    }
}

