/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.entities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FlowNodeType {
    UNSPECIFIED,
    PROCESS,
    SUB_PROCESS,
    EVENT_SUB_PROCESS,
    START_EVENT,
    INTERMEDIATE_CATCH_EVENT,
    BOUNDARY_EVENT,
    END_EVENT,
    SERVICE_TASK,
    USER_TASK,
    RECEIVE_TASK,
    EXCLUSIVE_GATEWAY,
    PARALLEL_GATEWAY,
    EVENT_BASED_GATEWAY,
    SEQUENCE_FLOW,
    MULTI_INSTANCE_BODY,
    CALL_ACTIVITY,
    UNKNOWN;

    private static final Logger LOGGER;

    public static FlowNodeType fromZeebeBpmnElementType(String bpmnElementType) {
        if (bpmnElementType == null) {
            return UNSPECIFIED;
        }
        try {
            return FlowNodeType.valueOf(bpmnElementType);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Flow node type not found for value [{}]. UNKNOWN type will be assigned.", (Object)bpmnElementType);
            return UNKNOWN;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(FlowNodeType.class);
    }
}

