/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.JwtAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.identity.IdentityConfig;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.Tokens;
import java.time.LocalDateTime;

public class SelfManagedAuthentication
extends JwtAuthentication {
    private final IdentityConfig identityConfig;

    public SelfManagedAuthentication(JwtConfig jwtConfig, IdentityConfig identityConfig) {
        super(jwtConfig);
        this.identityConfig = identityConfig;
    }

    public static SelfManagedAuthenticationBuilder builder() {
        return new SelfManagedAuthenticationBuilder();
    }

    @Override
    protected JwtAuthentication.JwtToken generateToken(Product product, JwtCredential credential) {
        Tokens token = this.getIdentityToken(product, credential);
        return new JwtAuthentication.JwtToken(token.getAccessToken(), LocalDateTime.now().plusSeconds(token.getExpiresIn()));
    }

    private Tokens getIdentityToken(Product product, JwtCredential credential) {
        Identity identity = this.identityConfig.get(product).getIdentity();
        String audience = credential.getAudience();
        return identity.authentication().requestToken(audience);
    }
}

