/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.auth;

import io.camunda.operate.auth.Authentication;
import io.camunda.operate.auth.JwtCredential;
import io.camunda.operate.auth.TokenResponse;
import io.camunda.operate.auth.TokenResponseMapper;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class JwtAuthentication
implements Authentication {
    private final JwtCredential jwtCredential;
    private final TokenResponseMapper tokenResponseMapper;
    private String token;
    private LocalDateTime timeout;

    public JwtAuthentication(JwtCredential jwtCredential, TokenResponseMapper tokenResponseMapper) {
        this.jwtCredential = jwtCredential;
        this.tokenResponseMapper = tokenResponseMapper;
    }

    @Deprecated
    public JwtCredential getJwtCredential() {
        return this.jwtCredential;
    }

    @Override
    public Map<String, String> getTokenHeader() {
        if (this.token == null || this.timeout == null || this.timeout.isBefore(LocalDateTime.now())) {
            TokenResponse response = this.retrieveToken();
            this.token = response.getAccessToken();
            this.timeout = LocalDateTime.now().plusSeconds(response.getExpiresIn().intValue()).minusSeconds(30L);
        }
        return Map.of("Authorization", "Bearer " + this.token);
    }

    @Override
    public void resetToken() {
        this.token = null;
        this.timeout = null;
    }

    private TokenResponse retrieveToken() {
        TokenResponse tokenResponse;
        block8: {
            CloseableHttpClient client = HttpClients.createSystem();
            try {
                HttpPost request = this.buildRequest();
                tokenResponse = (TokenResponse)client.execute((ClassicHttpRequest)request, response -> {
                    try {
                        return this.tokenResponseMapper.readToken(EntityUtils.toString((HttpEntity)response.getEntity()));
                    }
                    catch (Exception e) {
                        String errorMessage = String.format("Token retrieval failed from: %s\nResponse code: %s\nAudience: %s\n", this.jwtCredential.authUrl(), response.getCode(), this.jwtCredential.audience());
                        throw new RuntimeException(errorMessage, e);
                    }
                });
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Authenticating for Operate failed due to " + e.getMessage(), e);
                }
            }
            client.close();
        }
        return tokenResponse;
    }

    private HttpPost buildRequest() throws URISyntaxException {
        HttpPost httpPost = new HttpPost(this.jwtCredential.authUrl().toURI());
        httpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("grant_type", "client_credentials"));
        formParams.add(new BasicNameValuePair("client_id", this.jwtCredential.clientId()));
        formParams.add(new BasicNameValuePair("client_secret", this.jwtCredential.clientSecret()));
        formParams.add(new BasicNameValuePair("audience", this.jwtCredential.audience()));
        if (this.jwtCredential.scope() != null && !this.jwtCredential.scope().isEmpty()) {
            formParams.add(new BasicNameValuePair("scope", this.jwtCredential.scope()));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        return httpPost;
    }
}

