/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.Product;
import io.camunda.common.http.DefaultHttpClient;
import io.camunda.common.http.HttpClient;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.model.DecisionDefinition;
import io.camunda.operate.model.DecisionInstance;
import io.camunda.operate.model.DecisionRequirements;
import io.camunda.operate.model.FlowNodeInstance;
import io.camunda.operate.model.Incident;
import io.camunda.operate.model.ListTypeToken;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.operate.model.ProcessInstance;
import io.camunda.operate.model.SearchResultTypeToken;
import io.camunda.operate.model.Variable;
import java.util.HashMap;

public class CamundaOperateClientBuilder {
    private CamundaOperateClient client;
    private Authentication authentication;
    private String operateUrl;
    private HttpClient httpClient;

    public CamundaOperateClientBuilder authentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public CamundaOperateClientBuilder operateUrl(String operateUrl) {
        this.operateUrl = this.formatUrl(operateUrl);
        return this;
    }

    public CamundaOperateClientBuilder setup() {
        this.httpClient = new DefaultHttpClient(this.authentication);
        this.httpClient.init(this.operateUrl, "/v1");
        HashMap map = new HashMap();
        map.put(ProcessInstance.class, "/process-instances");
        map.put(ListTypeToken.listFlowNodeStatistics.getClass(), "/process-instances/{key}/statistics");
        map.put(ListTypeToken.listSequenceFlows.getClass(), "/process-instances/{key}/sequence-flows");
        map.put(ProcessDefinition.class, "/process-definitions");
        map.put(FlowNodeInstance.class, "/flownode-instances");
        map.put(Incident.class, "/incidents");
        map.put(Variable.class, "/variables");
        map.put(DecisionDefinition.class, "/decision-definitions");
        map.put(DecisionRequirements.class, "/drd");
        map.put(DecisionInstance.class, "/decision-instances");
        map.put(SearchResultTypeToken.searchResultProcessDefinition.getClass(), "/process-definitions/search");
        map.put(SearchResultTypeToken.searchResultDecisionDefinition.getClass(), "/decision-definitions/search");
        map.put(SearchResultTypeToken.searchResultDecisionInstance.getClass(), "/decision-instances/search");
        map.put(SearchResultTypeToken.searchResultFlowNodeInstance.getClass(), "/flownode-instances/search");
        map.put(SearchResultTypeToken.searchResultVariable.getClass(), "/variables/search");
        map.put(SearchResultTypeToken.searchResultProcessInstance.getClass(), "/process-instances/search");
        map.put(SearchResultTypeToken.searchResultDecisionRequirements.getClass(), "/drd/search");
        map.put(SearchResultTypeToken.searchResultIncident.getClass(), "/incidents/search");
        this.httpClient.loadMap(Product.OPERATE, map);
        return this;
    }

    private String formatUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public CamundaOperateClient build() {
        this.client = new CamundaOperateClient();
        this.client.setHttpClient(this.httpClient);
        return this.client;
    }
}

