/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.operate.webapp.rest.dto.UserDto;
import io.camunda.operate.webapp.security.AbstractUserService;
import io.camunda.operate.webapp.security.Permission;
import io.camunda.operate.webapp.security.identity.IdentityAuthentication;
import io.camunda.operate.webapp.security.identity.PermissionConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityUserService
extends AbstractUserService<AbstractAuthenticationToken> {
    private final Identity identity;
    private final PermissionConverter permissionConverter;

    @Autowired
    public IdentityUserService(Identity identity, PermissionConverter permissionConverter) {
        this.identity = identity;
        this.permissionConverter = permissionConverter;
    }

    @Override
    public UserDto createUserDtoFrom(AbstractAuthenticationToken authentication) {
        if (authentication instanceof IdentityAuthentication) {
            return new UserDto().setUserId(((IdentityAuthentication)authentication).getId()).setDisplayName(authentication.getName()).setCanLogout(true).setPermissions(((IdentityAuthentication)authentication).getPermissions()).setTenants(((IdentityAuthentication)authentication).getTenants());
        }
        if (authentication instanceof JwtAuthenticationToken) {
            AccessToken accessToken = this.identity.authentication().verifyToken(((Jwt)authentication.getPrincipal()).getTokenValue());
            List<Permission> permissions = accessToken.getPermissions().stream().map(this.permissionConverter::convert).collect(Collectors.toList());
            return new UserDto().setUserId(authentication.getName()).setDisplayName(authentication.getName()).setCanLogout(true).setPermissions(permissions);
        }
        return null;
    }

    @Override
    public String getUserToken(AbstractAuthenticationToken authentication) {
        throw new UnsupportedOperationException("Get token is not supported for Identity authentication");
    }
}

