/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.auth;

import io.camunda.operate.webapp.rest.dto.UserDto;
import io.camunda.operate.webapp.security.AbstractUserService;
import io.camunda.operate.webapp.security.auth.RolePermissionService;
import io.camunda.operate.webapp.security.auth.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!ldap-auth & ! sso-auth & !identity-auth & !auth-basic"})
public class AuthUserService
extends AbstractUserService<UsernamePasswordAuthenticationToken> {
    @Autowired
    private RolePermissionService rolePermissionService;

    @Override
    public UserDto createUserDtoFrom(UsernamePasswordAuthenticationToken authentication) {
        User user = (User)((Object)authentication.getPrincipal());
        return new UserDto().setUserId(user.getUserId()).setDisplayName(user.getDisplayName()).setCanLogout(true).setPermissions(this.rolePermissionService.getPermissions(user.getRoles()));
    }

    @Override
    public String getUserToken(UsernamePasswordAuthenticationToken authentication) {
        throw new UnsupportedOperationException("Get token is not supported for Elasticsearch authentication");
    }
}

