/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

public class OperateSession
implements Session {
    private final MapSession delegate;
    private boolean changed;
    private boolean polling;

    public OperateSession(String id) {
        this.delegate = new MapSession(id);
        this.polling = false;
    }

    boolean isChanged() {
        return this.changed;
    }

    void clearChangeFlag() {
        this.changed = false;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public OperateSession setId(String id) {
        this.delegate.setId(id);
        return this;
    }

    public String changeSessionId() {
        String newId = this.delegate.changeSessionId();
        this.changed = true;
        return newId;
    }

    public <T> T getAttribute(String attributeName) {
        return (T)this.delegate.getAttribute(attributeName);
    }

    public Set<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.delegate.setAttribute(attributeName, attributeValue);
        this.changed = true;
    }

    public void removeAttribute(String attributeName) {
        this.delegate.removeAttribute(attributeName);
        this.changed = true;
    }

    public Instant getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public void setCreationTime(Instant creationTime) {
        this.delegate.setCreationTime(creationTime);
        this.changed = true;
    }

    public boolean containsAuthentication() {
        return this.getAuthentication() != null;
    }

    public boolean isAuthenticated() {
        Authentication authentication = this.getAuthentication();
        return authentication != null && authentication.isAuthenticated();
    }

    private Authentication getAuthentication() {
        SecurityContext securityContext = (SecurityContext)this.delegate.getAttribute("SPRING_SECURITY_CONTEXT");
        Authentication authentication = securityContext != null ? securityContext.getAuthentication() : null;
        return authentication;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperateSession session = (OperateSession)o;
        return Objects.equals(this.getId(), session.getId());
    }

    public String toString() {
        return String.format("OperateSession: %s ", this.getId());
    }

    public Instant getLastAccessedTime() {
        return this.delegate.getLastAccessedTime();
    }

    public boolean isPolling() {
        return this.polling;
    }

    public OperateSession setPolling(boolean polling) {
        this.polling = polling;
        return this;
    }

    public void setLastAccessedTime(Instant lastAccessedTime) {
        this.delegate.setLastAccessedTime(lastAccessedTime);
        this.changed = true;
    }

    public Duration getMaxInactiveInterval() {
        return this.delegate.getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(Duration interval) {
        this.delegate.setMaxInactiveInterval(interval);
        this.changed = true;
    }

    public boolean isExpired() {
        return this.delegate.isExpired();
    }
}

