/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.activity;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.FlowNodeInstanceEntity;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeStateDto;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FlowNodeInstanceDto {
    private String id;
    private FlowNodeType type;
    private FlowNodeStateDto state;
    private String flowNodeId;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    private String treePath;
    private SortValuesWrapper[] sortValues;

    public static FlowNodeInstanceDto createFrom(FlowNodeInstanceEntity flowNodeInstanceEntity, ObjectMapper objectMapper) {
        FlowNodeInstanceDto instance = new FlowNodeInstanceDto().setId(flowNodeInstanceEntity.getId()).setFlowNodeId(flowNodeInstanceEntity.getFlowNodeId()).setStartDate(flowNodeInstanceEntity.getStartDate()).setEndDate(flowNodeInstanceEntity.getEndDate());
        if (flowNodeInstanceEntity.getState() == FlowNodeState.ACTIVE && flowNodeInstanceEntity.isIncident()) {
            instance.setState(FlowNodeStateDto.INCIDENT);
        } else {
            instance.setState(FlowNodeStateDto.getState(flowNodeInstanceEntity.getState()));
        }
        instance.setType(flowNodeInstanceEntity.getType()).setSortValues(SortValuesWrapper.createFrom(flowNodeInstanceEntity.getSortValues(), objectMapper)).setTreePath(flowNodeInstanceEntity.getTreePath());
        return instance;
    }

    public static List<FlowNodeInstanceDto> createFrom(List<FlowNodeInstanceEntity> flowNodeInstanceEntities, ObjectMapper objectMapper) {
        if (flowNodeInstanceEntities == null) {
            return new ArrayList<FlowNodeInstanceDto>();
        }
        return flowNodeInstanceEntities.stream().filter(item -> item != null).map(item -> FlowNodeInstanceDto.createFrom(item, objectMapper)).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public FlowNodeInstanceDto setId(String id) {
        this.id = id;
        return this;
    }

    public FlowNodeStateDto getState() {
        return this.state;
    }

    public FlowNodeInstanceDto setState(FlowNodeStateDto state) {
        this.state = state;
        return this;
    }

    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    public FlowNodeInstanceDto setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public FlowNodeInstanceDto setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public FlowNodeInstanceDto setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public FlowNodeType getType() {
        return this.type;
    }

    public FlowNodeInstanceDto setType(FlowNodeType type) {
        this.type = type;
        return this;
    }

    public String getTreePath() {
        return this.treePath;
    }

    public FlowNodeInstanceDto setTreePath(String treePath) {
        this.treePath = treePath;
        return this;
    }

    public SortValuesWrapper[] getSortValues() {
        return this.sortValues;
    }

    public FlowNodeInstanceDto setSortValues(SortValuesWrapper[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.id, this.type, this.state, this.flowNodeId, this.startDate, this.endDate, this.treePath});
        result = 31 * result + Arrays.hashCode(this.sortValues);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeInstanceDto that = (FlowNodeInstanceDto)o;
        return Objects.equals(this.id, that.id) && this.type == that.type && this.state == that.state && Objects.equals(this.flowNodeId, that.flowNodeId) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate) && Objects.equals(this.treePath, that.treePath) && Arrays.equals(this.sortValues, that.sortValues);
    }
}

