/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto;

import io.camunda.operate.entities.JobEntity;
import io.camunda.operate.entities.ListenerEventType;
import io.camunda.operate.entities.ListenerState;
import io.camunda.operate.entities.ListenerType;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;

public class ListenerDto {
    private ListenerType listenerType;
    private String listenerKey;
    private ListenerState state;
    private String jobType;
    private ListenerEventType event;
    private OffsetDateTime time;
    private SortValuesWrapper[] sortValues;

    public ListenerType getListenerType() {
        return this.listenerType;
    }

    public ListenerDto setListenerType(ListenerType listenerType) {
        this.listenerType = listenerType;
        return this;
    }

    public String getListenerKey() {
        return this.listenerKey;
    }

    public ListenerDto setListenerKey(String listenerKey) {
        this.listenerKey = listenerKey;
        return this;
    }

    public ListenerState getState() {
        return this.state;
    }

    public ListenerDto setState(ListenerState state) {
        this.state = state;
        return this;
    }

    public String getJobType() {
        return this.jobType;
    }

    public ListenerDto setJobType(String jobType) {
        this.jobType = jobType;
        return this;
    }

    public ListenerEventType getEvent() {
        return this.event;
    }

    public ListenerDto setEvent(ListenerEventType event) {
        this.event = event;
        return this;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public ListenerDto setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public SortValuesWrapper[] getSortValues() {
        return this.sortValues;
    }

    public ListenerDto setSortValues(SortValuesWrapper[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public static ListenerDto fromJobEntity(JobEntity jobEntity) {
        return new ListenerDto().setListenerType(ListenerType.fromZeebeJobKind((String)jobEntity.getJobKind())).setListenerKey(Long.toString(jobEntity.getKey())).setJobType(jobEntity.getType()).setState(ListenerState.fromZeebeJobIntent((String)jobEntity.getState())).setEvent(ListenerEventType.fromZeebeListenerEventType((String)jobEntity.getListenerEventType())).setTime(jobEntity.getEndTime());
    }

    public int hashCode() {
        return Objects.hash(this.listenerType, this.listenerKey, this.state, this.jobType, this.event, this.time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListenerDto that = (ListenerDto)o;
        return this.listenerType == that.listenerType && Objects.equals(this.listenerKey, that.listenerKey) && this.state == that.state && Objects.equals(this.jobType, that.jobType) && this.event == that.event && Objects.equals(this.time, that.time) && Arrays.equals(this.sortValues, that.sortValues);
    }

    public String toString() {
        return "ListenerDto{listenerType=" + String.valueOf(this.listenerType) + ", listenerKey='" + this.listenerKey + "', state=" + String.valueOf(this.state) + ", jobType='" + this.jobType + "', event=" + String.valueOf(this.event) + ", time=" + String.valueOf(this.time) + ", sortValues=" + Arrays.toString(this.sortValues) + "}";
    }
}

