/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.EventEntity;
import io.camunda.operate.entities.FlowNodeInstanceEntity;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.entities.UserTaskEntity;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.webapp.reader.DecisionInstanceReader;
import io.camunda.operate.webapp.reader.EventReader;
import io.camunda.operate.webapp.reader.ListViewReader;
import io.camunda.operate.webapp.reader.UserTaskReader;
import io.camunda.operate.webapp.rest.dto.metadata.BusinessRuleTaskInstanceMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.CallActivityInstanceMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadata;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.ServiceTaskInstanceMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.UserTaskInstanceMetadataDto;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FlowNodeInstanceMetadataBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowNodeInstanceMetadataBuilder.class);
    private final DecisionInstanceReader decisionInstanceReader;
    private final ListViewReader listViewReader;
    private final EventReader eventReader;
    private final UserTaskReader userTaskReader;
    private final Map<FlowNodeType, Function<FlowNodeInstanceEntity, FlowNodeInstanceMetadata>> flowNodeTypeToFlowNodeInstanceMetadata = Map.of(FlowNodeType.USER_TASK, this::getUserTaskInstanceMetadataDto, FlowNodeType.CALL_ACTIVITY, this::getCallActivityInstanceMetadataDto, FlowNodeType.BUSINESS_RULE_TASK, this::getBusinessRuleTaskInstanceMetadataDto, FlowNodeType.SERVICE_TASK, this::getServiceTaskInstanceMetadataDto);

    public FlowNodeInstanceMetadataBuilder(ListViewReader listViewReader, DecisionInstanceReader decisionInstanceReader, EventReader eventReader, UserTaskReader userTaskReader) {
        this.listViewReader = listViewReader;
        this.decisionInstanceReader = decisionInstanceReader;
        this.eventReader = eventReader;
        this.userTaskReader = userTaskReader;
    }

    public FlowNodeInstanceMetadata buildFrom(FlowNodeInstanceEntity flowNodeInstance) {
        FlowNodeType type = flowNodeInstance.getType();
        if (type == null) {
            LOGGER.error(String.format("FlowNodeType for FlowNodeInstance with id %s is null", flowNodeInstance.getId()));
            return null;
        }
        Function<FlowNodeInstanceEntity, FlowNodeInstanceMetadata> flowNodeInstanceMetadataProvider = this.flowNodeTypeToFlowNodeInstanceMetadata.getOrDefault(type, this::getDefaultFlowNodeInstanceMetadataDto);
        return flowNodeInstanceMetadataProvider.apply(flowNodeInstance);
    }

    private FlowNodeInstanceMetadataDto getDefaultFlowNodeInstanceMetadataDto(FlowNodeInstanceEntity flowNodeInstanceEntity) {
        EventEntity event = this.eventReader.getEventEntityByFlowNodeInstanceId(flowNodeInstanceEntity.getId());
        return new FlowNodeInstanceMetadataDto(flowNodeInstanceEntity.getFlowNodeId(), flowNodeInstanceEntity.getId(), flowNodeInstanceEntity.getType(), flowNodeInstanceEntity.getStartDate(), flowNodeInstanceEntity.getEndDate(), event);
    }

    private BusinessRuleTaskInstanceMetadataDto getBusinessRuleTaskInstanceMetadataDto(FlowNodeInstanceEntity flowNodeInstance) {
        Tuple<String, String> instanceIdAndDefinitionName = this.decisionInstanceReader.getCalledDecisionInstanceAndDefinitionByFlowNodeInstanceId(flowNodeInstance.getId());
        EventEntity event = this.eventReader.getEventEntityByFlowNodeInstanceId(flowNodeInstance.getId());
        String calledDecisionInstanceId = (String)instanceIdAndDefinitionName.getLeft();
        String calledDecisionDefinitionName = (String)instanceIdAndDefinitionName.getRight();
        return new BusinessRuleTaskInstanceMetadataDto(flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType(), flowNodeInstance.getStartDate(), flowNodeInstance.getEndDate(), event, calledDecisionInstanceId, calledDecisionDefinitionName);
    }

    private UserTaskInstanceMetadataDto getUserTaskInstanceMetadataDto(FlowNodeInstanceEntity flowNodeInstance) {
        Optional<UserTaskEntity> userTask = this.userTaskReader.getUserTaskByFlowNodeInstanceKey(flowNodeInstance.getKey());
        EventEntity event = this.eventReader.getEventEntityByFlowNodeInstanceId(flowNodeInstance.getId());
        UserTaskInstanceMetadataDto result = new UserTaskInstanceMetadataDto(flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType(), flowNodeInstance.getStartDate(), flowNodeInstance.getEndDate(), event);
        if (userTask.isPresent()) {
            UserTaskEntity task = userTask.get();
            result.setUserTaskKey(task.getUserTaskKey()).setAssignee(task.getAssignee()).setCandidateUsers(task.getCandidateUsers()).setCandidateGroups(task.getCandidateGroups()).setAction(task.getAction()).setDueDate(task.getDueDate()).setFollowUpDate(task.getFollowUpDate()).setChangedAttributes(task.getChangedAttributes()).setTenantId(task.getTenantId()).setFormKey(task.getFormKey()).setExternalReference(task.getExternalReference());
            try {
                result.setVariables((Map)new ObjectMapper().readValue((Reader)new StringReader(task.getVariables()), Map.class));
            }
            catch (IOException e) {
                result.setVariables(Map.of());
            }
        }
        return result;
    }

    private CallActivityInstanceMetadataDto getCallActivityInstanceMetadataDto(FlowNodeInstanceEntity flowNodeInstance) {
        Tuple<String, String> processInstanceIdAndName = this.listViewReader.getCalledProcessInstanceIdAndNameByFlowNodeInstanceId(flowNodeInstance.getId());
        EventEntity event = this.eventReader.getEventEntityByFlowNodeInstanceId(flowNodeInstance.getId());
        String calledProcessInstanceId = (String)processInstanceIdAndName.getLeft();
        String calledProcessDefinitionName = (String)processInstanceIdAndName.getRight();
        return new CallActivityInstanceMetadataDto(flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType(), flowNodeInstance.getStartDate(), flowNodeInstance.getEndDate(), event, calledProcessInstanceId, calledProcessDefinitionName);
    }

    private ServiceTaskInstanceMetadataDto getServiceTaskInstanceMetadataDto(FlowNodeInstanceEntity flowNodeInstance) {
        EventEntity event = this.eventReader.getEventEntityByFlowNodeInstanceId(flowNodeInstance.getId());
        return new ServiceTaskInstanceMetadataDto(flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType(), flowNodeInstance.getStartDate(), flowNodeInstance.getEndDate(), event);
    }
}

