/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.ListViewStore;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.OperationStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.util.ExceptionHelper;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.opensearch.OpenSearchQueryHelper;
import io.camunda.operate.webapp.reader.IncidentReader;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.operation.CreateBatchOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.security.UserService;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.camunda.operate.webapp.writer.BatchOperationWriter;
import io.camunda.operate.webapp.writer.PersistOperationHelper;
import io.camunda.operate.webapp.writer.ProcessInstanceSource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchBatchOperationWriter
implements BatchOperationWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchBatchOperationWriter.class);
    @Autowired
    private IncidentReader incidentReader;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private OperationTemplate operationTemplate;
    @Autowired
    private OperationReader operationReader;
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private UserService userService;
    @Autowired
    private ProcessInstanceReader processInstanceReader;
    @Autowired(required=false)
    private PermissionsService permissionsService;
    @Autowired
    private OperationStore operationStore;
    @Autowired
    private ListViewStore listViewStore;
    @Autowired
    private OpenSearchQueryHelper openSearchQueryHelper;
    @Autowired
    private PersistOperationHelper persistOperationHelper;

    @Override
    public List<OperationEntity> lockBatch() throws PersistenceException {
        String workerId = this.operateProperties.getOperationExecutor().getWorkerId();
        long lockTimeout = this.operateProperties.getOperationExecutor().getLockTimeout();
        int batchSize = this.operateProperties.getOperationExecutor().getBatchSize();
        List<OperationEntity> operationEntities = this.operationReader.acquireOperations(batchSize);
        BatchRequest batchRequest = this.operationStore.newBatchRequest();
        for (OperationEntity operation : operationEntities) {
            operation.setState(OperationState.LOCKED);
            operation.setLockOwner(workerId);
            operation.setLockExpirationTime(OffsetDateTime.now().plus(lockTimeout, ChronoUnit.MILLIS));
            batchRequest.update(this.operationTemplate.getFullQualifiedName(), operation.getId(), (OperateEntity)operation);
        }
        batchRequest.executeWithRefresh();
        LOGGER.debug("{} operations locked", (Object)operationEntities.size());
        return operationEntities;
    }

    @Override
    public void updateOperation(OperationEntity operation) throws PersistenceException {
        this.operationStore.update(operation, true);
    }

    @Override
    public BatchOperationEntity scheduleBatchOperation(CreateBatchOperationRequestDto batchOperationRequest) {
        LOGGER.debug("Creating batch operation: operationRequest [{}]", (Object)batchOperationRequest);
        try {
            BatchOperationEntity batchOperation = this.createBatchOperationEntity(batchOperationRequest.getOperationType(), batchOperationRequest.getName());
            int operationsCount = this.addOperations(batchOperationRequest, batchOperation);
            batchOperation.setOperationsTotalCount(Integer.valueOf(operationsCount));
            if (operationsCount == 0) {
                batchOperation.setEndDate(OffsetDateTime.now());
            }
            this.operationStore.add(batchOperation);
            return batchOperation;
        }
        catch (InvalidRequestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OperateRuntimeException(String.format("Exception occurred, while scheduling operation: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public BatchOperationEntity scheduleSingleOperation(long processInstanceKey, CreateOperationRequestDto operationRequest) {
        LOGGER.debug("Creating operation: processInstanceKey [{}], operation type [{}]", (Object)processInstanceKey, (Object)operationRequest.getOperationType());
        try {
            BatchOperationEntity batchOperation = this.createBatchOperationEntity(operationRequest.getOperationType(), operationRequest.getName());
            BatchRequest batchRequest = this.operationStore.newBatchRequest();
            int operationsCount = 0;
            String noOperationsReason = null;
            OperationType operationType = operationRequest.getOperationType();
            if (operationType.equals((Object)OperationType.RESOLVE_INCIDENT) && operationRequest.getIncidentId() == null) {
                List<IncidentEntity> allIncidents = this.incidentReader.getAllIncidentsByProcessInstanceKey(processInstanceKey);
                if (allIncidents.size() == 0) {
                    batchOperation.setEndDate(OffsetDateTime.now());
                    noOperationsReason = "No incidents found.";
                } else {
                    for (IncidentEntity incident : allIncidents) {
                        OperationEntity operationEntity = this.createOperationEntity(processInstanceKey, operationType, batchOperation.getId());
                        operationEntity.setIncidentKey(Long.valueOf(incident.getKey()));
                        batchRequest.add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity);
                        ++operationsCount;
                    }
                }
            } else if (Set.of(OperationType.UPDATE_VARIABLE, OperationType.ADD_VARIABLE).contains(operationType)) {
                operationEntity = this.createOperationEntity(processInstanceKey, operationType, batchOperation.getId()).setScopeKey(ConversionUtils.toLongOrNull((String)operationRequest.getVariableScopeId())).setVariableName(operationRequest.getVariableName()).setVariableValue(operationRequest.getVariableValue());
                batchRequest.add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity);
                ++operationsCount;
            } else {
                operationEntity = this.createOperationEntity(processInstanceKey, operationType, batchOperation.getId()).setIncidentKey(ConversionUtils.toLongOrNull((String)operationRequest.getIncidentId()));
                batchRequest.add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity);
                ++operationsCount;
            }
            String processInstanceId = String.valueOf(processInstanceKey);
            Map processInstanceIdToIndexName = this.listViewStore.getListViewIndicesForProcessInstances(List.of(Long.valueOf(processInstanceKey)));
            String indexForProcessInstance = (String)CollectionUtil.getOrDefaultForNullValue((Map)processInstanceIdToIndexName, (Object)processInstanceKey, (Object)this.listViewTemplate.getFullQualifiedName());
            String script = "if (ctx._source.batchOperationIds == null){ctx._source.batchOperationIds = new String[]{params.batchOperationId};} else {ctx._source.batchOperationIds.add(params.batchOperationId);}";
            batchRequest.updateWithScript(indexForProcessInstance, processInstanceId, "if (ctx._source.batchOperationIds == null){ctx._source.batchOperationIds = new String[]{params.batchOperationId};} else {ctx._source.batchOperationIds.add(params.batchOperationId);}", Map.of("batchOperationId", batchOperation.getId()));
            batchOperation.setOperationsTotalCount(Integer.valueOf(operationsCount));
            batchOperation.setInstancesCount(Integer.valueOf(1));
            batchRequest.add(this.batchOperationTemplate.getFullQualifiedName(), (OperateEntity)batchOperation);
            batchRequest.execute();
            return batchOperation;
        }
        catch (NotFoundException nfe) {
            throw new OperateRuntimeException(String.format("Exception occurred, while scheduling operation: %s", nfe.getMessage()), (Throwable)new io.camunda.operate.webapp.rest.exception.NotFoundException(nfe.getMessage()));
        }
        catch (Exception ex) {
            throw new OperateRuntimeException(String.format("Exception occurred, while scheduling operation: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public BatchOperationEntity scheduleModifyProcessInstance(ModifyProcessInstanceRequestDto modifyRequest) {
        LOGGER.debug("Creating modify process instance operation: processInstanceKey [{}]", (Object)modifyRequest.getProcessInstanceKey());
        try {
            int operationsCount = modifyRequest.getModifications().size();
            Long processInstanceKey = Long.parseLong(modifyRequest.getProcessInstanceKey());
            BatchOperationEntity batchOperation = this.createBatchOperationEntity(OperationType.MODIFY_PROCESS_INSTANCE, null).setOperationsTotalCount(Integer.valueOf(operationsCount)).setInstancesCount(Integer.valueOf(1));
            OperationEntity operationEntity = this.createOperationEntity(processInstanceKey, OperationType.MODIFY_PROCESS_INSTANCE, batchOperation.getId()).setModifyInstructions(this.objectMapper.writeValueAsString((Object)modifyRequest));
            BatchRequest batchRequest = this.operationStore.newBatchRequest();
            Map processInstanceIdToIndexName = this.listViewStore.getListViewIndicesForProcessInstances(List.of(processInstanceKey));
            String processInstanceId = String.valueOf(processInstanceKey);
            String indexForProcessInstance = (String)CollectionUtil.getOrDefaultForNullValue((Map)processInstanceIdToIndexName, (Object)processInstanceKey, (Object)this.listViewTemplate.getFullQualifiedName());
            Map<String, String> params = Map.of("batchOperationId", batchOperation.getId());
            String script = "if (ctx._source.batchOperationIds == null){ctx._source.batchOperationIds = new String[]{params.batchOperationId};} else {ctx._source.batchOperationIds.add(params.batchOperationId);}";
            batchRequest.add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity).updateWithScript(indexForProcessInstance, processInstanceId, "if (ctx._source.batchOperationIds == null){ctx._source.batchOperationIds = new String[]{params.batchOperationId};} else {ctx._source.batchOperationIds.add(params.batchOperationId);}", params).add(this.batchOperationTemplate.getFullQualifiedName(), (OperateEntity)batchOperation);
            batchRequest.execute();
            return batchOperation;
        }
        catch (Exception ex) {
            throw new OperateRuntimeException(String.format("Exception occurred, while scheduling 'modify process instance' operation: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public BatchOperationEntity scheduleDeleteDecisionDefinition(DecisionDefinitionEntity decisionDefinitionEntity) {
        Long decisionDefinitionKey = decisionDefinitionEntity.getKey();
        OperationType operationType = OperationType.DELETE_DECISION_DEFINITION;
        String batchOperationName = String.format("%s - Version %s", decisionDefinitionEntity.getName(), decisionDefinitionEntity.getVersion());
        BatchOperationEntity batchOperation = this.createBatchOperationEntity(operationType, batchOperationName).setOperationsTotalCount(Integer.valueOf(1)).setInstancesCount(Integer.valueOf(0));
        OperationEntity operationEntity = new OperationEntity();
        operationEntity.generateId();
        operationEntity.setDecisionDefinitionKey(decisionDefinitionKey);
        operationEntity.setType(operationType);
        operationEntity.setState(OperationState.SCHEDULED);
        operationEntity.setBatchOperationId(batchOperation.getId());
        operationEntity.setUsername(this.userService.getCurrentUser().getUsername());
        try {
            BatchRequest batchRequest = this.operationStore.newBatchRequest().add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity).add(this.batchOperationTemplate.getFullQualifiedName(), (OperateEntity)batchOperation);
            batchRequest.execute();
            return batchOperation;
        }
        catch (Exception ex) {
            throw new OperateRuntimeException(String.format("Exception occurred, while scheduling 'delete decision definition' operation: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public BatchOperationEntity scheduleDeleteProcessDefinition(ProcessEntity processEntity) {
        Long processDefinitionKey = processEntity.getKey();
        OperationType operationType = OperationType.DELETE_PROCESS_DEFINITION;
        String batchOperationName = String.format("%s - Version %s", processEntity.getName(), processEntity.getVersion());
        BatchOperationEntity batchOperation = this.createBatchOperationEntity(operationType, batchOperationName).setOperationsTotalCount(Integer.valueOf(1)).setInstancesCount(Integer.valueOf(0));
        OperationEntity operationEntity = new OperationEntity();
        operationEntity.generateId();
        operationEntity.setProcessDefinitionKey(processDefinitionKey);
        operationEntity.setType(operationType);
        operationEntity.setState(OperationState.SCHEDULED);
        operationEntity.setBatchOperationId(batchOperation.getId());
        operationEntity.setUsername(this.userService.getCurrentUser().getUsername());
        try {
            BatchRequest batchRequest = this.operationStore.newBatchRequest().add(this.operationTemplate.getFullQualifiedName(), (OperateEntity)operationEntity).add(this.batchOperationTemplate.getFullQualifiedName(), (OperateEntity)batchOperation);
            batchRequest.execute();
            return batchOperation;
        }
        catch (Exception ex) {
            throw new OperateRuntimeException(String.format("Exception occurred, while scheduling 'delete process definition' operation: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    private int addOperations(CreateBatchOperationRequestDto batchOperationRequest, BatchOperationEntity batchOperation) throws IOException {
        int batchSize = this.operateProperties.getElasticsearch().getBatchSize();
        Query query = this.openSearchQueryHelper.createProcessInstancesQuery(batchOperationRequest.getQuery());
        if (this.permissionsService != null) {
            IdentityPermission permission = batchOperationRequest.getOperationType() == OperationType.DELETE_PROCESS_INSTANCE ? IdentityPermission.DELETE_PROCESS_INSTANCE : IdentityPermission.UPDATE_PROCESS_INSTANCE;
            PermissionsService.ResourcesAllowed allowed = this.permissionsService.getProcessesWithPermission(permission);
            Query permissionQuery = allowed.isAll() ? QueryDSL.matchAll() : QueryDSL.stringTerms((String)"bpmnProcessId", allowed.getIds());
            query = QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{query, permissionQuery})));
        }
        RequestDSL.QueryType queryType = batchOperationRequest.getOperationType() == OperationType.DELETE_PROCESS_INSTANCE ? RequestDSL.QueryType.ALL : RequestDSL.QueryType.ONLY_RUNTIME;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.listViewTemplate, (RequestDSL.QueryType)queryType).query(query).size(Integer.valueOf(batchSize)).source(QueryDSL.sourceInclude((String[])new String[]{"processInstanceKey", "processDefinitionKey", "bpmnProcessId"}));
        AtomicInteger operationsCount = new AtomicInteger();
        Consumer<List> hitsConsumer = hits -> ExceptionHelper.withOperateRuntimeException(() -> {
            List<ProcessInstanceSource> processInstanceSources = hits.stream().map(Hit::source).toList();
            return operationsCount.addAndGet(this.persistOperationHelper.persistOperations(processInstanceSources, batchOperation.getId(), batchOperationRequest, null));
        });
        Consumer<HitsMetadata> hitsMetadataConsumer = hitsMeta -> {
            this.validateTotalHits((HitsMetadata<?>)hitsMeta);
            batchOperation.setInstancesCount(Integer.valueOf((int)hitsMeta.total().value()));
        };
        this.richOpenSearchClient.doc().unsafeScrollWith(searchRequestBuilder, hitsConsumer, hitsMetadataConsumer, ProcessInstanceSource.class, false);
        return operationsCount.get();
    }

    private void validateTotalHits(HitsMetadata<?> hitsMeta) {
        long totalHits = hitsMeta.total().value();
        Long maxSize = this.operateProperties.getBatchOperationMaxSize();
        if (maxSize != null && totalHits > this.operateProperties.getBatchOperationMaxSize()) {
            throw new InvalidRequestException(String.format("Too many process instances are selected for batch operation. Maximum possible amount: %s", maxSize));
        }
    }

    private BatchOperationEntity createBatchOperationEntity(OperationType operationType, String name) {
        BatchOperationEntity batchOperationEntity = new BatchOperationEntity();
        batchOperationEntity.generateId();
        batchOperationEntity.setType(operationType);
        batchOperationEntity.setName(name);
        batchOperationEntity.setStartDate(OffsetDateTime.now());
        batchOperationEntity.setUsername(this.userService.getCurrentUser().getUsername());
        return batchOperationEntity;
    }

    private OperationEntity createOperationEntity(Long processInstanceKey, OperationType operationType, String batchOperationId) {
        ProcessInstanceSource processInstanceSource = new ProcessInstanceSource().setProcessInstanceKey(processInstanceKey);
        Optional<ProcessInstanceForListViewEntity> optionalProcessInstance = this.tryGetProcessInstance(processInstanceKey);
        optionalProcessInstance.ifPresent(processInstance -> processInstanceSource.setProcessDefinitionKey(processInstance.getProcessDefinitionKey()).setBpmnProcessId(processInstance.getBpmnProcessId()));
        return this.createOperationEntity(processInstanceSource, operationType, batchOperationId);
    }

    private OperationEntity createOperationEntity(ProcessInstanceSource processInstanceSource, OperationType operationType, String batchOperationId) {
        OperationEntity operationEntity = new OperationEntity();
        operationEntity.generateId();
        operationEntity.setProcessInstanceKey(processInstanceSource.getProcessInstanceKey());
        operationEntity.setProcessDefinitionKey(processInstanceSource.getProcessDefinitionKey());
        operationEntity.setBpmnProcessId(processInstanceSource.getBpmnProcessId());
        operationEntity.setType(operationType);
        operationEntity.setState(OperationState.SCHEDULED);
        operationEntity.setBatchOperationId(batchOperationId);
        operationEntity.setUsername(this.userService.getCurrentUser().getUsername());
        return operationEntity;
    }

    private Optional<ProcessInstanceForListViewEntity> tryGetProcessInstance(Long processInstanceKey) {
        ProcessInstanceForListViewEntity processInstance = null;
        try {
            processInstance = this.processInstanceReader.getProcessInstanceByKey(processInstanceKey);
        }
        catch (OperateRuntimeException ex) {
            LOGGER.error(String.format("Failed to get process instance for key %s: %s", processInstanceKey, ex.getMessage()));
        }
        return Optional.ofNullable(processInstance);
    }
}

