/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.Convertable;
import io.camunda.operate.util.MapPath;
import io.camunda.operate.webapp.opensearch.OpenSearchQueryHelper;
import io.camunda.operate.webapp.reader.FlowNodeStatisticsReader;
import io.camunda.operate.webapp.rest.dto.FlowNodeStatisticsDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewQueryDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.ChildrenAggregation;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchFlowNodeStatisticsReader
implements FlowNodeStatisticsReader {
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private OpenSearchQueryHelper openSearchQueryHelper;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;

    @Override
    public Collection<FlowNodeStatisticsDto> getFlowNodeStatistics(ListViewQueryDto query) {
        SearchRequest.Builder searchRequest = !query.isFinished() ? this.createQuery(query, RequestDSL.QueryType.ONLY_RUNTIME) : this.createQuery(query, RequestDSL.QueryType.ALL);
        Map<String, FlowNodeStatisticsDto> statisticsMap = this.runQueryAndCollectStats(searchRequest);
        return statisticsMap.values();
    }

    private SearchRequest.Builder createQuery(ListViewQueryDto query, RequestDSL.QueryType queryType) {
        HashMap<String, Aggregation> subAggregations = new HashMap<String, Aggregation>();
        if (query.isActive()) {
            subAggregations.put("active_activities", this.getActiveFlowNodesAggregation());
        }
        if (query.isCanceled()) {
            subAggregations.put("terminated_activities", this.getTerminatedActivitiesAggregation());
        }
        if (query.isIncidents()) {
            subAggregations.put("incident_activities", this.getIncidentActivitiesAggregation());
        }
        subAggregations.put("finished_activities", this.getFinishedActivitiesAggregation());
        return RequestDSL.searchRequestBuilder((TemplateDescriptor)this.listViewTemplate, (RequestDSL.QueryType)queryType).query(QueryDSL.withTenantCheck((Query)QueryDSL.constantScore((Query)this.openSearchQueryHelper.createQueryFragment(query, queryType)))).size(Integer.valueOf(0)).aggregations("activities", AggregationDSL.withSubaggregations((ChildrenAggregation)AggregationDSL.children((String)"activity"), subAggregations));
    }

    private Aggregation getTerminatedActivitiesAggregation() {
        return AggregationDSL.withSubaggregations((Query)QueryDSL.term((String)"activityState", (String)FlowNodeState.TERMINATED.name()), this.uniqueActivitiesAggregation());
    }

    private Aggregation getActiveFlowNodesAggregation() {
        return AggregationDSL.withSubaggregations((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"incident", (boolean)false), QueryDSL.term((String)"activityState", (String)FlowNodeState.ACTIVE.toString())}), this.uniqueActivitiesAggregation());
    }

    private Aggregation getIncidentActivitiesAggregation() {
        return AggregationDSL.withSubaggregations((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"incident", (boolean)true), QueryDSL.term((String)"activityState", (String)FlowNodeState.ACTIVE.toString())}), this.uniqueActivitiesAggregation());
    }

    private Aggregation getFinishedActivitiesAggregation() {
        return AggregationDSL.withSubaggregations((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"activityType", (String)FlowNodeType.END_EVENT.toString()), QueryDSL.term((String)"activityState", (String)FlowNodeState.COMPLETED.toString())}), this.uniqueActivitiesAggregation());
    }

    private Map<String, Aggregation> uniqueActivitiesAggregation() {
        return Map.of("unique_activities", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"activityId", (int)10000), Map.of("activity_to_process", AggregationDSL.parent((String)"activity")._toAggregation())));
    }

    private Map<String, FlowNodeStatisticsDto> runQueryAndCollectStats(SearchRequest.Builder searchRequest) {
        HashMap<String, FlowNodeStatisticsDto> statisticsMap = new HashMap<String, FlowNodeStatisticsDto>();
        Map result = this.richOpenSearchClient.doc().searchAsMap(searchRequest);
        Optional maybeActivities = MapPath.from((Map)result).getByPath(new String[]{"aggregations", "children#activities"}).flatMap(Convertable::to);
        maybeActivities.ifPresent(activities -> CollectionUtil.asMap((Object[])new Object[]{"active_activities", FlowNodeStatisticsDto::addActive, "incident_activities", FlowNodeStatisticsDto::addIncidents, "terminated_activities", FlowNodeStatisticsDto::addCanceled, "finished_activities", FlowNodeStatisticsDto::addCompleted}).forEach((aggName, mapUpdater) -> this.collectStatisticsFor((Map<String, FlowNodeStatisticsDto>)statisticsMap, (Map<String, Object>)activities, (String)aggName, (MapUpdater)mapUpdater)));
        return statisticsMap;
    }

    private void collectStatisticsFor(Map<String, FlowNodeStatisticsDto> statisticsMap, Map<String, Object> activities, String aggName, MapUpdater mapUpdater) {
        Optional maybeUniqueActivitiesBuckets = MapPath.from(activities).getByPath(new String[]{"filter#" + aggName, "sterms#unique_activities", "buckets"}).flatMap(Convertable::to);
        maybeUniqueActivitiesBuckets.ifPresent(buckets -> buckets.forEach(bucket -> {
            String activityId = (String)bucket.get("key");
            long docCount = ((Integer)MapPath.from((Map)bucket).getByPath(new String[]{"parent#activity_to_process", "doc_count"}).flatMap(Convertable::to).get()).intValue();
            statisticsMap.putIfAbsent(activityId, new FlowNodeStatisticsDto(activityId));
            mapUpdater.updateMapEntry((FlowNodeStatisticsDto)statisticsMap.get(activityId), docCount);
        }));
    }

    @FunctionalInterface
    private static interface MapUpdater {
        public void updateMapEntry(FlowNodeStatisticsDto var1, Long var2);
    }
}

