/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.webapp.reader.DecisionReader;
import io.camunda.operate.webapp.rest.dto.DecisionRequestDto;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDecisionReader
implements DecisionReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchDecisionReader.class);
    @Autowired
    private DecisionIndex decisionIndex;
    @Autowired
    private DecisionRequirementsIndex decisionRequirementsIndex;
    @Autowired(required=false)
    private PermissionsService permissionsService;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;

    @Override
    public String getDiagram(Long decisionDefinitionKey) {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder((String)this.decisionIndex.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.ids((String[])new String[]{decisionDefinitionKey.toString()})));
        record DecisionRequirementsIdRecord(Long decisionRequirementsKey) {
        }
        HitsMetadata hits = this.richOpenSearchClient.doc().search(request, DecisionRequirementsIdRecord.class).hits();
        if (hits.total().value() == 0L) {
            throw new NotFoundException("No decision definition found for id " + decisionDefinitionKey);
        }
        Long decisionRequirementsId = ((DecisionRequirementsIdRecord)((Hit)hits.hits().get((int)0)).source()).decisionRequirementsKey;
        SearchRequest.Builder xmlRequest = RequestDSL.searchRequestBuilder((String)this.decisionRequirementsIndex.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.ids((String[])new String[]{decisionRequirementsId.toString()}))).source(QueryDSL.sourceInclude((String[])new String[]{"xml"}));
        record XmlRecord(String xml) {
        }
        HitsMetadata xmlHits = this.richOpenSearchClient.doc().search(xmlRequest, XmlRecord.class).hits();
        if (xmlHits.total().value() == 1L) {
            return ((XmlRecord)((Hit)xmlHits.hits().get((int)0)).source()).xml;
        }
        if (hits.total().value() > 1L) {
            throw new NotFoundException(String.format("Could not find unique DRD with id '%s'.", decisionRequirementsId));
        }
        throw new NotFoundException(String.format("Could not find DRD with id '%s'.", decisionRequirementsId));
    }

    @Override
    public DecisionDefinitionEntity getDecision(Long decisionDefinitionKey) {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder((String)this.decisionIndex.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"key", (Long)decisionDefinitionKey)));
        HitsMetadata hits = this.richOpenSearchClient.doc().search(request, DecisionDefinitionEntity.class).hits();
        if (hits.total().value() == 1L) {
            return (DecisionDefinitionEntity)((Hit)hits.hits().get(0)).source();
        }
        if (hits.total().value() > 1L) {
            throw new NotFoundException(String.format("Could not find unique decision with key '%s'.", decisionDefinitionKey));
        }
        throw new NotFoundException(String.format("Could not find decision with key '%s'.", decisionDefinitionKey));
    }

    @Override
    public Map<String, List<DecisionDefinitionEntity>> getDecisionsGrouped(DecisionRequestDto request) {
        String tenantsGroupsAggName = "group_by_tenantId";
        String groupsAggName = "group_by_decisionId";
        String decisionsAggName = "decisions";
        List<String> sourceFields = List.of("id", "name", "version", "decisionId", "tenantId");
        SearchRequest.Builder aggregationsRequest = RequestDSL.searchRequestBuilder((String)this.decisionIndex.getAlias()).query(QueryDSL.withTenantCheck((Query)this.buildQuery(request.getTenantId()))).size(Integer.valueOf(0)).aggregations("group_by_tenantId", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"tenantId", (int)10000), Map.of("group_by_decisionId", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"decisionId", (int)10000), Map.of("decisions", AggregationDSL.topHitsAggregation(sourceFields, (int)100, (SortOptions[])new SortOptions[]{QueryDSL.sortOptions((String)"version", (SortOrder)SortOrder.Desc)})._toAggregation())))));
        HashMap<String, List<DecisionDefinitionEntity>> result = new HashMap<String, List<DecisionDefinitionEntity>>();
        SearchResponse response = this.richOpenSearchClient.doc().search(aggregationsRequest, Object.class);
        ((Aggregate)response.aggregations().get("group_by_tenantId")).sterms().buckets().array().forEach(tenantBucket -> ((Aggregate)tenantBucket.aggregations().get("group_by_decisionId")).sterms().buckets().array().forEach(decisionIdBucket -> {
            String key = tenantBucket.key() + "_" + decisionIdBucket.key();
            List<DecisionDefinitionEntity> value = ((Aggregate)decisionIdBucket.aggregations().get("decisions")).topHits().hits().hits().stream().map(h -> (DecisionDefinitionEntity)((JsonData)h.source()).to(DecisionDefinitionEntity.class)).toList();
            result.put(key, value);
        }));
        return result;
    }

    private Query buildQuery(String tenantId) {
        Query query;
        PermissionsService.ResourcesAllowed allowed;
        Query decisionIdQuery = null;
        if (this.permissionsService != null && (allowed = this.permissionsService.getDecisionsWithPermission(IdentityPermission.READ)) != null && !allowed.isAll()) {
            decisionIdQuery = QueryDSL.stringTerms((String)"decisionId", allowed.getIds());
        }
        Query tenantIdQuery = null;
        if (this.operateProperties.getMultiTenancy().isEnabled()) {
            tenantIdQuery = tenantId != null ? QueryDSL.term((String)"tenantId", (String)tenantId) : null;
        }
        return (query = QueryDSL.and((Query[])new Query[]{decisionIdQuery, tenantIdQuery})) == null ? QueryDSL.matchAll() : query;
    }
}

