/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.rest.dto.DecisionRequestDto;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class DecisionReader
extends AbstractReader
implements io.camunda.operate.webapp.reader.DecisionReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionReader.class);
    @Autowired
    private DecisionIndex decisionIndex;
    @Autowired
    private DecisionRequirementsIndex decisionRequirementsIndex;
    @Autowired(required=false)
    private PermissionsService permissionsService;
    @Autowired
    private OperateProperties operateProperties;

    private DecisionDefinitionEntity fromSearchHit(String processString) {
        return (DecisionDefinitionEntity)ElasticsearchUtil.fromSearchHit((String)processString, (ObjectMapper)this.objectMapper, DecisionDefinitionEntity.class);
    }

    @Override
    public String getDiagram(Long decisionDefinitionKey) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{decisionDefinitionKey.toString()})));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 0L) {
                throw new NotFoundException("No decision definition found for id " + decisionDefinitionKey);
            }
            Object key = response.getHits().getHits()[0].getSourceAsMap().get("decisionRequirementsKey");
            Long decisionRequirementsId = Long.valueOf(String.valueOf(key));
            searchRequest = new SearchRequest(new String[]{this.decisionRequirementsIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{String.valueOf(decisionRequirementsId)})).fetchSource("xml", null));
            response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                Map result = response.getHits().getHits()[0].getSourceAsMap();
                return (String)result.get("xml");
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique DRD with id '%s'.", decisionRequirementsId));
            }
            throw new NotFoundException(String.format("Could not find DRD with id '%s'.", decisionRequirementsId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the decision diagram: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public DecisionDefinitionEntity getDecision(Long decisionDefinitionKey) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)decisionDefinitionKey)));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                return this.fromSearchHit(response.getHits().getHits()[0].getSourceAsString());
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique decision with key '%s'.", decisionDefinitionKey));
            }
            throw new NotFoundException(String.format("Could not find decision with key '%s'.", decisionDefinitionKey));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the decision: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<String, List<DecisionDefinitionEntity>> getDecisionsGrouped(DecisionRequestDto request) {
        String tenantsGroupsAggName = "group_by_tenantId";
        String groupsAggName = "group_by_decisionId";
        String decisionsAggName = "decisions";
        AbstractAggregationBuilder agg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_tenantId").field("tenantId")).size(10000).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_decisionId").field("decisionId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"decisions").fetchSource(new String[]{"id", "name", "version", "decisionId", "tenantId"}, null).size(100).sort("version", SortOrder.DESC)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)agg).size(0);
        sourceBuilder.query(this.buildQuery(request.getTenantId()));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionIndex.getAlias()}).source(sourceBuilder);
        try {
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            Terms groups = (Terms)searchResponse.getAggregations().get("group_by_tenantId");
            HashMap<String, List<DecisionDefinitionEntity>> result = new HashMap<String, List<DecisionDefinitionEntity>>();
            groups.getBuckets().stream().forEach(b -> {
                String groupTenantId = b.getKeyAsString();
                Terms decisionGroups = (Terms)b.getAggregations().get("group_by_decisionId");
                decisionGroups.getBuckets().stream().forEach(tenantB -> {
                    SearchHit[] hits;
                    String decisionId = tenantB.getKeyAsString();
                    String groupKey = groupTenantId + "_" + decisionId;
                    result.put(groupKey, new ArrayList());
                    TopHits processes = (TopHits)tenantB.getAggregations().get("decisions");
                    for (SearchHit searchHit : hits = processes.getHits().getHits()) {
                        DecisionDefinitionEntity decisionEntity = this.fromSearchHit(searchHit.getSourceAsString());
                        ((List)result.get(groupKey)).add(decisionEntity);
                    }
                });
            });
            return result;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining grouped processes: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private QueryBuilder buildQuery(String tenantId) {
        QueryBuilder q;
        PermissionsService.ResourcesAllowed allowed;
        TermsQueryBuilder decisionIdQ = null;
        if (this.permissionsService != null && (allowed = this.permissionsService.getDecisionsWithPermission(IdentityPermission.READ)) != null && !allowed.isAll()) {
            decisionIdQ = QueryBuilders.termsQuery((String)"decisionId", allowed.getIds());
        }
        TermQueryBuilder tenantIdQ = null;
        if (this.operateProperties.getMultiTenancy().isEnabled()) {
            TermQueryBuilder termQueryBuilder = tenantIdQ = tenantId != null ? QueryBuilders.termQuery((String)"tenantId", (String)tenantId) : null;
        }
        if ((q = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{decisionIdQ, tenantIdQ})) == null) {
            q = QueryBuilders.matchAllQuery();
        }
        return q;
    }
}

