/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.rest;

import io.camunda.operate.webapp.api.v1.entities.Error;
import io.camunda.operate.webapp.api.v1.exceptions.ClientException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.api.v1.exceptions.ValidationException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class ErrorController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Error> handleAccessDeniedException(AccessDeniedException exception) {
        this.logger.error(this.getSummary((Exception)exception));
        this.logger.debug(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setType(exception.getClass().getSimpleName()).setInstance(UUID.randomUUID().toString()).setStatus(HttpStatus.FORBIDDEN.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ClientException.class})
    public ResponseEntity<Error> handleInvalidRequest(ClientException exception) {
        this.logger.error(this.getSummary(exception));
        this.logger.debug(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setType("Invalid request").setInstance(exception.getInstance()).setStatus(HttpStatus.BAD_REQUEST.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Error> handleException(Exception exception) {
        return this.handleInvalidRequest(new ClientException(this.getOnlyDetailMessage(exception), exception));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Error> handleInvalidRequest(ValidationException exception) {
        this.logger.error(this.getSummary(exception));
        this.logger.debug(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setType("Data invalid").setInstance(exception.getInstance()).setStatus(HttpStatus.BAD_REQUEST.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<Error> handleNotFound(ResourceNotFoundException exception) {
        this.logger.error(this.getSummary(exception));
        this.logger.debug(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setType("Requested resource not found").setInstance(exception.getInstance()).setStatus(HttpStatus.NOT_FOUND.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ServerException.class})
    public ResponseEntity<Error> handleServerException(ServerException exception) {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setType("API application error").setInstance(exception.getInstance()).setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    private String getOnlyDetailMessage(Exception exception) {
        return StringUtils.substringBefore((String)exception.getMessage(), (String)"; nested exception is");
    }

    private String getSummary(Exception exception) {
        return String.format("%s: %s", exception.getClass().getSimpleName(), exception.getMessage());
    }
}

