/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.templates.SequenceFlowTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.SequenceFlowDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchSearchableDao;
import io.camunda.operate.webapp.api.v1.entities.SequenceFlow;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchSequenceFlowDao
extends OpensearchSearchableDao<SequenceFlow, SequenceFlow>
implements SequenceFlowDao {
    private final SequenceFlowTemplate sequenceFlowIndex;

    public OpensearchSequenceFlowDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, SequenceFlowTemplate sequenceFlowIndex) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.sequenceFlowIndex = sequenceFlowIndex;
    }

    @Override
    protected String getUniqueSortKey() {
        return "id";
    }

    @Override
    protected Class<SequenceFlow> getInternalDocumentModelClass() {
        return SequenceFlow.class;
    }

    @Override
    protected String getIndexName() {
        return this.sequenceFlowIndex.getAlias();
    }

    @Override
    protected void buildFiltering(io.camunda.operate.webapp.api.v1.entities.Query<SequenceFlow> query, SearchRequest.Builder request) {
        List<Query> queryTerms;
        SequenceFlow filter = query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("id", filter.getId()), this.queryDSLWrapper.term("activityId", filter.getActivityId()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("processInstanceKey", filter.getProcessInstanceKey())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    @Override
    protected SequenceFlow convertInternalToApiResult(SequenceFlow internalResult) {
        return internalResult;
    }
}

