/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.indices.ProcessIndex;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.ProcessDefinitionDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.ProcessDefinition;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchProcessDefinitionDao
extends OpensearchKeyFilteringDao<ProcessDefinition, ProcessDefinition>
implements ProcessDefinitionDao {
    private final ProcessIndex processIndex;

    public OpensearchProcessDefinitionDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, ProcessIndex processIndex) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.processIndex = processIndex;
    }

    @Override
    protected String getKeyFieldName() {
        return "key";
    }

    @Override
    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading process definition for key %s", key);
    }

    @Override
    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No process definition found for key %s", key);
    }

    @Override
    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one process definition for key %s", key);
    }

    @Override
    public String xmlByKey(Long key) throws APIException {
        this.validateKey(key);
        SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.processIndex.getAlias()).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.term("key", key))).source(this.queryDSLWrapper.sourceInclude("bpmnXml"));
        try {
            SearchResponse response = this.richOpenSearchClient.doc().search(request, Map.class);
            if (response.hits().total().value() == 1L) {
                return ((Map)((Hit)response.hits().hits().get(0)).source()).get("bpmnXml").toString();
            }
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading process definition as xml for key %s", key), e);
        }
        throw new ResourceNotFoundException(String.format("Process definition for key %s not found.", key));
    }

    @Override
    protected String getUniqueSortKey() {
        return "key";
    }

    @Override
    protected Class<ProcessDefinition> getInternalDocumentModelClass() {
        return ProcessDefinition.class;
    }

    @Override
    protected String getIndexName() {
        return this.processIndex.getAlias();
    }

    @Override
    protected void buildFiltering(io.camunda.operate.webapp.api.v1.entities.Query<ProcessDefinition> query, SearchRequest.Builder request) {
        List<Query> queryTerms;
        ProcessDefinition filter = query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("name", filter.getName()), this.queryDSLWrapper.term("bpmnProcessId", filter.getBpmnProcessId()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("version", filter.getVersion()), this.queryDSLWrapper.term("key", filter.getKey())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    @Override
    protected ProcessDefinition convertInternalToApiResult(ProcessDefinition internalResult) {
        return internalResult;
    }
}

