/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.connect.OperateDateTimeFormatter;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.FlowNodeInstanceDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.FlowNodeInstance;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchFlowNodeInstanceDao
extends OpensearchKeyFilteringDao<FlowNodeInstance, FlowNodeInstance>
implements FlowNodeInstanceDao {
    private final FlowNodeInstanceTemplate flowNodeInstanceIndex;
    private final ProcessCache processCache;
    private final OperateDateTimeFormatter dateTimeFormatter;

    public OpensearchFlowNodeInstanceDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, FlowNodeInstanceTemplate flowNodeInstanceIndex, ProcessCache processCache, OperateDateTimeFormatter dateTimeFormatter) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.flowNodeInstanceIndex = flowNodeInstanceIndex;
        this.processCache = processCache;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected String getKeyFieldName() {
        return "key";
    }

    @Override
    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading flownode instance for key %s", key);
    }

    @Override
    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No flownode instance found for key %s", key);
    }

    @Override
    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one flownode instances for key %s", key);
    }

    @Override
    protected String getUniqueSortKey() {
        return "key";
    }

    @Override
    protected Class<FlowNodeInstance> getInternalDocumentModelClass() {
        return FlowNodeInstance.class;
    }

    @Override
    protected String getIndexName() {
        return this.flowNodeInstanceIndex.getAlias();
    }

    @Override
    protected void buildFiltering(io.camunda.operate.webapp.api.v1.entities.Query<FlowNodeInstance> query, SearchRequest.Builder request) {
        List<Query> queryTerms;
        FlowNodeInstance filter = query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("key", filter.getKey()), this.queryDSLWrapper.term("processInstanceKey", filter.getProcessInstanceKey()), this.queryDSLWrapper.term("processDefinitionKey", filter.getProcessDefinitionKey()), this.queryDSLWrapper.matchDateQuery("startDate", filter.getStartDate(), this.dateTimeFormatter.getApiDateTimeFormatString()), this.queryDSLWrapper.matchDateQuery("endDate", filter.getEndDate(), this.dateTimeFormatter.getApiDateTimeFormatString()), this.queryDSLWrapper.term("state", filter.getState()), this.queryDSLWrapper.term("type", filter.getType()), this.queryDSLWrapper.term("flowNodeId", filter.getFlowNodeId()), this.queryDSLWrapper.term("incident", filter.getIncident()), this.queryDSLWrapper.term("incidentKey", filter.getIncidentKey()), this.queryDSLWrapper.term("tenantId", filter.getTenantId())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    @Override
    protected FlowNodeInstance convertInternalToApiResult(FlowNodeInstance internalResult) {
        if (internalResult != null) {
            if (StringUtils.isNotEmpty((CharSequence)internalResult.getStartDate())) {
                internalResult.setStartDate(this.dateTimeFormatter.convertGeneralToApiDateTime(internalResult.getStartDate()));
            }
            if (StringUtils.isNotEmpty((CharSequence)internalResult.getEndDate())) {
                internalResult.setEndDate(this.dateTimeFormatter.convertGeneralToApiDateTime(internalResult.getEndDate()));
            }
            if (internalResult.getFlowNodeId() != null) {
                String flowNodeName = this.processCache.getFlowNodeNameOrDefaultValue(internalResult.getProcessDefinitionKey(), internalResult.getFlowNodeId(), null);
                internalResult.setFlowNodeName(flowNodeName);
            }
        }
        return internalResult;
    }
}

