/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.connect.OperateDateTimeFormatter;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.DecisionInstanceDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchSearchableDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionInstance;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDecisionInstanceDao
extends OpensearchSearchableDao<DecisionInstance, DecisionInstance>
implements DecisionInstanceDao {
    private final DecisionInstanceTemplate decisionInstanceTemplate;
    private final OperateDateTimeFormatter dateTimeFormatter;

    public OpensearchDecisionInstanceDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, DecisionInstanceTemplate decisionInstanceTemplate, OperateDateTimeFormatter dateTimeFormatter) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.decisionInstanceTemplate = decisionInstanceTemplate;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public DecisionInstance byId(String id) throws APIException {
        List decisionInstances;
        if (id == null) {
            throw new ServerException("ID provided cannot be null");
        }
        try {
            SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.getIndexName()).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.term("id", id)));
            decisionInstances = this.richOpenSearchClient.doc().searchValues(request, this.getInternalDocumentModelClass());
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading decision instance for id %s", id), e);
        }
        if (decisionInstances.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No decision instance found for id %s", id));
        }
        if (decisionInstances.size() > 1) {
            throw new ServerException(String.format("Found more than one decision instance for id %s", id));
        }
        return this.convertInternalToApiResult((DecisionInstance)decisionInstances.get(0));
    }

    @Override
    protected SearchRequest.Builder buildSearchRequest(io.camunda.operate.webapp.api.v1.entities.Query<DecisionInstance> query) {
        return super.buildSearchRequest(query).source(this.queryDSLWrapper.sourceExclude("evaluatedInputs", "evaluatedOutputs"));
    }

    @Override
    protected String getUniqueSortKey() {
        return "id";
    }

    @Override
    protected Class<DecisionInstance> getInternalDocumentModelClass() {
        return DecisionInstance.class;
    }

    @Override
    protected String getIndexName() {
        return this.decisionInstanceTemplate.getAlias();
    }

    @Override
    protected void buildFiltering(io.camunda.operate.webapp.api.v1.entities.Query<DecisionInstance> query, SearchRequest.Builder request) {
        List<Query> queryTerms;
        DecisionInstance filter = query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("id", filter.getId()), this.queryDSLWrapper.term("key", filter.getKey()), this.queryDSLWrapper.term("state", filter.getState() == null ? null : filter.getState().name()), this.queryDSLWrapper.matchDateQuery("evaluationDate", filter.getEvaluationDate(), this.dateTimeFormatter.getApiDateTimeFormatString()), this.queryDSLWrapper.term("evaluationFailure", filter.getEvaluationFailure()), this.queryDSLWrapper.term("processDefinitionKey", filter.getProcessDefinitionKey()), this.queryDSLWrapper.term("processInstanceKey", filter.getProcessInstanceKey()), this.queryDSLWrapper.term("decisionId", filter.getDecisionId()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("decisionDefinitionId", filter.getDecisionDefinitionId()), this.queryDSLWrapper.term("decisionName", filter.getDecisionName()), this.queryDSLWrapper.term("decisionVersion", filter.getDecisionVersion()), this.queryDSLWrapper.term("decisionType", filter.getDecisionType() == null ? null : filter.getDecisionType().name())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    @Override
    protected DecisionInstance convertInternalToApiResult(DecisionInstance internalResult) {
        if (internalResult != null && StringUtils.isNotEmpty((CharSequence)internalResult.getEvaluationDate())) {
            internalResult.setEvaluationDate(this.dateTimeFormatter.convertGeneralToApiDateTime(internalResult.getEvaluationDate()));
        }
        return internalResult;
    }
}

