/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.ProcessInstanceDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.ChangeStatus;
import io.camunda.operate.webapp.api.v1.entities.ProcessInstance;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ClientException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.writer.ProcessInstanceWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchProcessInstanceDaoV1")
public class ElasticsearchProcessInstanceDao
extends ElasticsearchDao<ProcessInstance>
implements ProcessInstanceDao {
    @Autowired
    private ListViewTemplate processInstanceIndex;
    @Autowired
    private ProcessInstanceWriter processInstanceWriter;

    private List<ProcessInstance> mapSearchHits(SearchHit[] searchHitArray) {
        List processInstances = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, (ObjectMapper)this.objectMapper, ProcessInstance.class);
        if (processInstances != null) {
            for (ProcessInstance pi : processInstances) {
                pi.setStartDate(this.dateTimeFormatter.convertGeneralToApiDateTime(pi.getStartDate()));
                pi.setEndDate(this.dateTimeFormatter.convertGeneralToApiDateTime(pi.getEndDate()));
            }
        }
        return processInstances;
    }

    @Override
    public Results<ProcessInstance> search(Query<ProcessInstance> query) throws APIException {
        this.logger.debug("search {}", query);
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "processInstanceKey", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.processInstanceIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List<ProcessInstance> processInstances = this.mapSearchHits(searchHitArray);
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(processInstances).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading process instances", e);
        }
    }

    @Override
    public ProcessInstance byKey(Long key) throws APIException {
        List<ProcessInstance> processInstances;
        this.logger.debug("byKey {}", (Object)key);
        try {
            processInstances = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading process instance for key %s", key), e);
        }
        if (processInstances.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No process instances found for key %s ", key));
        }
        if (processInstances.size() > 1) {
            throw new ServerException(String.format("Found more than one process instances for key %s", key));
        }
        return processInstances.get(0);
    }

    @Override
    @PreAuthorize(value="hasPermission('write')")
    public ChangeStatus delete(Long key) throws APIException {
        this.byKey(key);
        try {
            this.processInstanceWriter.deleteInstanceById(key);
            return new ChangeStatus().setDeleted(1L).setMessage(String.format("Process instance and dependant data deleted for key '%s'", key));
        }
        catch (IllegalArgumentException iae) {
            throw new ClientException(iae.getMessage(), iae);
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in deleting process instance and dependant data for key '%s'", key), e);
        }
    }

    @Override
    protected void buildFiltering(Query<ProcessInstance> query, SearchSourceBuilder searchSourceBuilder) {
        ProcessInstance filter = query.getFilter();
        ArrayList<Object> queryBuilders = new ArrayList<Object>();
        queryBuilders.add(QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance"));
        if (filter != null) {
            queryBuilders.add(this.buildTermQuery("processInstanceKey", filter.getKey()));
            queryBuilders.add(this.buildTermQuery("processDefinitionKey", filter.getProcessDefinitionKey()));
            queryBuilders.add(this.buildTermQuery("parentProcessInstanceKey", filter.getParentKey()));
            queryBuilders.add(this.buildTermQuery("parentFlowNodeInstanceKey", filter.getParentFlowNodeInstanceKey()));
            queryBuilders.add(this.buildTermQuery("processVersion", filter.getProcessVersion()));
            queryBuilders.add(this.buildTermQuery("processVersionTag", filter.getProcessVersionTag()));
            queryBuilders.add(this.buildTermQuery("bpmnProcessId", filter.getBpmnProcessId()));
            queryBuilders.add(this.buildTermQuery("state", filter.getState()));
            queryBuilders.add(this.buildTermQuery("incident", filter.getIncident()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildMatchDateQuery("startDate", filter.getStartDate()));
            queryBuilders.add(this.buildMatchDateQuery("endDate", filter.getEndDate()));
        }
        searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
    }

    protected List<ProcessInstance> searchFor(SearchSourceBuilder searchSource) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processInstanceIndex.getAlias()}).source(searchSource);
        List processInstances = (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, ProcessInstance.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.elasticsearch));
        if (processInstances != null) {
            for (ProcessInstance pi : processInstances) {
                pi.setStartDate(this.dateTimeFormatter.convertGeneralToApiDateTime(pi.getStartDate()));
                pi.setEndDate(this.dateTimeFormatter.convertGeneralToApiDateTime(pi.getEndDate()));
            }
        }
        return processInstances;
    }
}

