/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.FlowNodeStatisticsDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.FlowNodeStatistics;
import io.camunda.operate.webapp.api.v1.entities.Query;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchFlowNodeStatisticsDaoV1")
public class ElasticsearchFlowNodeStatisticsDao
extends ElasticsearchDao<FlowNodeStatistics>
implements FlowNodeStatisticsDao {
    @Autowired
    private FlowNodeInstanceTemplate flowNodeInstanceTemplate;

    @Override
    protected void buildFiltering(Query<FlowNodeStatistics> query, SearchSourceBuilder searchSourceBuilder) {
        FlowNodeStatistics filter = query.getFilter();
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        if (filter != null) {
            queryBuilders.add(this.buildTermQuery("activityId", filter.getActivityId()));
        }
        searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
    }

    @Override
    public List<FlowNodeStatistics> getFlowNodeStatisticsForProcessInstance(Long processInstanceKey) {
        try {
            SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceKey))).aggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"flowNodeIdAgg").field("flowNodeId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countIncident", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)true))))).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countCanceled", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)FlowNodeType.MULTI_INSTANCE_BODY)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.TERMINATED))))).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countCompleted", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)FlowNodeType.MULTI_INSTANCE_BODY)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.COMPLETED))))).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countActive", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)FlowNodeType.MULTI_INSTANCE_BODY)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.ACTIVE)).must((QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)false))))).size(0));
            SearchResponse response = this.tenantAwareClient.search(request);
            Aggregations aggregations = response.getAggregations();
            Terms flowNodeAgg = (Terms)aggregations.get("flowNodeIdAgg");
            return flowNodeAgg.getBuckets().stream().map(bucket -> new FlowNodeStatistics().setActivityId(bucket.getKeyAsString()).setCanceled(((Filter)bucket.getAggregations().get("countCanceled")).getDocCount()).setIncidents(((Filter)bucket.getAggregations().get("countIncident")).getDocCount()).setCompleted(((Filter)bucket.getAggregations().get("countCompleted")).getDocCount()).setActive(((Filter)bucket.getAggregations().get("countActive")).getDocCount())).collect(Collectors.toList());
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining statistics for process instance flow nodes: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

