/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.store;

import io.camunda.document.api.DocumentCreationRequest;
import io.camunda.document.api.DocumentError;
import io.camunda.document.api.DocumentLink;
import io.camunda.document.api.DocumentReference;
import io.camunda.document.api.DocumentStore;
import io.camunda.zeebe.util.Either;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryDocumentStore
implements DocumentStore {
    private final Map<String, byte[]> documents = new ConcurrentHashMap<String, byte[]>();

    public CompletableFuture<Either<DocumentError, DocumentReference>> createDocument(DocumentCreationRequest request) {
        byte[] content;
        String id = Optional.ofNullable(request.documentId()).orElse(UUID.randomUUID().toString());
        if (this.documents.containsKey(id)) {
            return CompletableFuture.completedFuture(Either.left((Object)new DocumentError.DocumentAlreadyExists(id)));
        }
        InputStream contentInputStream = request.contentInputStream();
        try {
            content = contentInputStream.readAllBytes();
            contentInputStream.close();
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(Either.left((Object)new DocumentError.InvalidInput("Failed to read content")));
        }
        this.documents.put(id, content);
        return CompletableFuture.completedFuture(Either.right((Object)new DocumentReference(id, request.metadata())));
    }

    public CompletableFuture<Either<DocumentError, InputStream>> getDocument(String documentId) {
        byte[] content = this.documents.get(documentId);
        if (content == null) {
            return CompletableFuture.completedFuture(Either.left((Object)new DocumentError.DocumentNotFound(documentId)));
        }
        return CompletableFuture.completedFuture(Either.right((Object)new ByteArrayInputStream(content)));
    }

    public CompletableFuture<Either<DocumentError, Void>> deleteDocument(String documentId) {
        byte[] content = this.documents.remove(documentId);
        if (content == null) {
            return CompletableFuture.completedFuture(Either.left((Object)new DocumentError.DocumentNotFound(documentId)));
        }
        return CompletableFuture.completedFuture(Either.right(null));
    }

    public CompletableFuture<Either<DocumentError, DocumentLink>> createLink(String documentId, long durationInSeconds) {
        return CompletableFuture.completedFuture(Either.left((Object)new DocumentError.OperationNotSupported("The in-memory document instance does not support creating links")));
    }
}

