/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.CorrelatedMessageSubscriptionSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.CorrelatedMessageSubscription;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.CorrelatedMessageSubscriptionSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.CorrelatedMessageSubscriptionFilter;
import io.camunda.client.protocol.rest.CorrelatedMessageSubscriptionSearchQuery;
import io.camunda.client.protocol.rest.CorrelatedMessageSubscriptionSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class CorrelatedMessageSubscriptionSearchRequestImpl
extends TypedSearchRequestPropertyProvider<CorrelatedMessageSubscriptionSearchQuery>
implements CorrelatedMessageSubscriptionSearchRequest {
    private final CorrelatedMessageSubscriptionSearchQuery request = new CorrelatedMessageSubscriptionSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CorrelatedMessageSubscriptionSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<CorrelatedMessageSubscription> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<CorrelatedMessageSubscription>> send() {
        HttpCamundaFuture<SearchResponse<CorrelatedMessageSubscription>> result = new HttpCamundaFuture<SearchResponse<CorrelatedMessageSubscription>>();
        this.httpClient.post("correlated-message-subscriptions/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), CorrelatedMessageSubscriptionSearchQueryResult.class, SearchResponseMapper::toCorrelatedMessageSubscriptionSearchResponse, result);
        return result;
    }

    @Override
    public CorrelatedMessageSubscriptionSearchRequest filter(io.camunda.client.api.search.filter.CorrelatedMessageSubscriptionFilter value) {
        this.request.setFilter((CorrelatedMessageSubscriptionFilter)CorrelatedMessageSubscriptionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public CorrelatedMessageSubscriptionSearchRequest filter(Consumer<io.camunda.client.api.search.filter.CorrelatedMessageSubscriptionFilter> fn) {
        return this.filter(SearchRequestBuilders.correlatedMessageSubscriptionFilter(fn));
    }

    @Override
    public CorrelatedMessageSubscriptionSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)CorrelatedMessageSubscriptionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public CorrelatedMessageSubscriptionSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public CorrelatedMessageSubscriptionSearchRequest sort(CorrelatedMessageSubscriptionSort value) {
        this.request.setSort(SearchRequestSortMapper.toCorrelatedMessageSubscriptionSearchQuerySortRequest((List)CorrelatedMessageSubscriptionSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public CorrelatedMessageSubscriptionSearchRequest sort(Consumer<CorrelatedMessageSubscriptionSort> fn) {
        return this.sort(SearchRequestBuilders.correlatedMessageSubscriptionSort(fn));
    }

    @Override
    protected CorrelatedMessageSubscriptionSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

