/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.ResumeBatchOperationStep1;
import io.camunda.client.api.response.ResumeBatchOperationResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.ResumeBatchOperationResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class ResumeBatchOperationCommandImpl
implements ResumeBatchOperationStep1 {
    private final String batchOperationKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ResumeBatchOperationCommandImpl(HttpClient httpClient, String batchOperationKey) {
        this.batchOperationKey = batchOperationKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<ResumeBatchOperationResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<ResumeBatchOperationResponse> send() {
        HttpCamundaFuture<ResumeBatchOperationResponse> result = new HttpCamundaFuture<ResumeBatchOperationResponse>();
        this.httpClient.post("/batch-operations/" + this.batchOperationKey + "/resumption", null, this.httpRequestConfig.build(), ResumeBatchOperationResponseImpl::new, result);
        return result;
    }
}

