/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateTimeoutJobCommandStep1;
import io.camunda.client.api.response.UpdateTimeoutJobResponse;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateTimeoutJobResponseImpl;
import io.camunda.client.protocol.rest.JobChangeset;
import io.camunda.client.protocol.rest.JobUpdateRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public class JobUpdateTimeoutCommandImpl
implements UpdateTimeoutJobCommandStep1,
UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.UpdateJobTimeoutRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private boolean useRest;
    private final JobUpdateRequest httpRequestObject;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long jobKey;
    private final JsonMapper jsonMapper;

    public JobUpdateTimeoutCommandImpl(GatewayGrpc.GatewayStub asyncStub, long jobKey, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.UpdateJobTimeoutRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(jobKey);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobUpdateRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = jobKey;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 timeout(long timeout) {
        this.grpcRequestObjectBuilder.setTimeout(timeout);
        this.getChangesetEnsureInitialized().setTimeout(timeout);
        return this;
    }

    @Override
    public UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 timeout(Duration timeout) {
        return this.timeout(timeout.toMillis());
    }

    @Override
    public FinalCommandStep<UpdateTimeoutJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateTimeoutJobResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private CamundaFuture<UpdateTimeoutJobResponse> sendRestRequest() {
        HttpCamundaFuture<UpdateTimeoutJobResponse> result = new HttpCamundaFuture<UpdateTimeoutJobResponse>();
        this.httpClient.patch("/jobs/" + this.jobKey, this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), UpdateTimeoutJobResponseImpl::new, result);
        return result;
    }

    private CamundaFuture<UpdateTimeoutJobResponse> sendGrpcRequest() {
        GatewayOuterClass.UpdateJobTimeoutRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<UpdateTimeoutJobResponse, GatewayOuterClass.UpdateJobTimeoutResponse> future = new RetriableClientFutureImpl<UpdateTimeoutJobResponse, GatewayOuterClass.UpdateJobTimeoutResponse>(UpdateTimeoutJobResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.UpdateJobTimeoutRequest request, StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).updateJobTimeout(request, streamObserver);
    }

    @Override
    public UpdateTimeoutJobCommandStep1.UpdateTimeoutJobCommandStep2 operationReference(long operationReference) {
        this.grpcRequestObjectBuilder.setOperationReference(operationReference);
        this.httpRequestObject.setOperationReference(operationReference);
        return this;
    }

    @Override
    public UpdateTimeoutJobCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public UpdateTimeoutJobCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    private JobChangeset getChangesetEnsureInitialized() {
        JobChangeset changeset = this.httpRequestObject.getChangeset();
        if (changeset == null) {
            changeset = new JobChangeset();
            this.httpRequestObject.setChangeset(changeset);
        }
        return changeset;
    }
}

