/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CompleteUserTaskCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CompleteUserTaskResponse;
import io.camunda.client.impl.command.CommandWithVariables;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CompleteUserTaskResponseImpl;
import io.camunda.client.protocol.rest.UserTaskCompletionRequest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CompleteUserTaskCommandImpl
extends CommandWithVariables<CompleteUserTaskCommandStep1>
implements CompleteUserTaskCommandStep1 {
    private final long userTaskKey;
    private final UserTaskCompletionRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CompleteUserTaskCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        super(jsonMapper);
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskCompletionRequest();
    }

    @Override
    public FinalCommandStep<CompleteUserTaskResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CompleteUserTaskResponse> send() {
        HttpCamundaFuture<CompleteUserTaskResponse> result = new HttpCamundaFuture<CompleteUserTaskResponse>();
        this.httpClient.post("/user-tasks/" + this.userTaskKey + "/completion", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), CompleteUserTaskResponseImpl::new, result);
        return result;
    }

    @Override
    public CompleteUserTaskCommandStep1 action(String action) {
        this.request.setAction(action);
        return this;
    }

    @Override
    protected CompleteUserTaskCommandStep1 setVariablesInternal(String variables) {
        this.request.setVariables(this.objectMapper.fromJsonAsMap(variables));
        return this;
    }
}

