/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.CancelBatchOperationStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CancelBatchOperationResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CancelBatchOperationResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CancelBatchOperationCommandImpl
implements CancelBatchOperationStep1 {
    private final String batchOperationKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CancelBatchOperationCommandImpl(HttpClient httpClient, String batchOperationKey) {
        this.batchOperationKey = batchOperationKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<CancelBatchOperationResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CancelBatchOperationResponse> send() {
        HttpCamundaFuture<CancelBatchOperationResponse> result = new HttpCamundaFuture<CancelBatchOperationResponse>();
        this.httpClient.post("/batch-operations/" + this.batchOperationKey + "/cancellation", null, this.httpRequestConfig.build(), CancelBatchOperationResponseImpl::new, result);
        return result;
    }
}

