/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignClientToGroupCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignClientToGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.AssignClientToGroupResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignClientToGroupCommandImpl
implements AssignClientToGroupCommandStep1,
AssignClientToGroupCommandStep1.AssignClientToGroupCommandStep2,
AssignClientToGroupCommandStep1.AssignClientToGroupCommandStep3 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String clientId;
    private String groupId;

    public AssignClientToGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignClientToGroupCommandStep1.AssignClientToGroupCommandStep2 clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public AssignClientToGroupCommandStep1.AssignClientToGroupCommandStep3 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignClientToGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignClientToGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("clientId", this.clientId);
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<AssignClientToGroupResponse> result = new HttpCamundaFuture<AssignClientToGroupResponse>();
        this.httpClient.put("/groups/" + this.groupId + "/clients/" + this.clientId, null, this.httpRequestConfig.build(), AssignClientToGroupResponseImpl::new, result);
        return result;
    }
}

