/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Predicate;

public final class ArgumentUtil {
    public static void ensureNotNull(String property, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(property + " must not be null");
        }
    }

    public static void ensureNotEmpty(String property, String value) {
        ArgumentUtil.ensureNotEmpty(property, value, String::isEmpty);
    }

    public static void ensureNotNullNorEmpty(String property, String value) {
        ArgumentUtil.ensureNotNull(property, value);
        ArgumentUtil.ensureNotEmpty(property, value);
    }

    public static void ensureGreaterThan(String property, long testValue, long comparisonValue) {
        if (testValue <= comparisonValue) {
            throw new IllegalArgumentException(property + " must be greater than " + comparisonValue);
        }
    }

    public static void ensureNotNegative(String property, long testValue) {
        if (testValue < 0L) {
            throw new IllegalArgumentException(String.format("%s must be not negative", property));
        }
    }

    public static void ensureNotNegative(String property, Duration testValue) {
        ArgumentUtil.ensureNotNegative(property, testValue.toMillis());
    }

    public static void ensureNotZero(String property, Duration testValue) {
        if (testValue.isZero()) {
            throw new IllegalArgumentException(String.format("%s must be not zero", property));
        }
    }

    public static void ensurePositive(String property, Duration testValue) {
        ArgumentUtil.ensureNotNegative(property, testValue);
        ArgumentUtil.ensureNotZero(property, testValue);
    }

    public static void ensureNotBefore(String property, Instant testValue, Instant otherInstant) {
        if (testValue.isBefore(otherInstant)) {
            throw new IllegalArgumentException(String.format("%s must be equal to or after %s", property, otherInstant));
        }
    }

    public static void ensureNotEmpty(String property, List<?> value) {
        ArgumentUtil.ensureNotEmpty(property, value, List::isEmpty);
    }

    public static void ensureNotNullOrEmpty(String property, List<?> value) {
        ArgumentUtil.ensureNotNull(property, value);
        ArgumentUtil.ensureNotEmpty(property, value);
    }

    private static <T> void ensureNotEmpty(String property, T value, Predicate<T> isEmptyPredicate) {
        if (isEmptyPredicate.test(value)) {
            throw new IllegalArgumentException(property + " must not be empty");
        }
    }
}

