/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.basicauth;

import io.camunda.client.CredentialsProvider;
import java.util.Base64;

public class BasicAuthCredentialsProvider
implements CredentialsProvider {
    public static final String AUTH_HEADER_KEY = "Authorization";
    private final String authHeaderValue;

    BasicAuthCredentialsProvider(String username, String password) {
        String base64EncodedCredentials = Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes());
        this.authHeaderValue = String.format("Basic %s", base64EncodedCredentials);
    }

    @Override
    public void applyCredentials(CredentialsProvider.CredentialsApplier applier) {
        applier.put(AUTH_HEADER_KEY, this.authHeaderValue);
    }

    @Override
    public boolean shouldRetryRequest(CredentialsProvider.StatusCode statusCode) {
        return false;
    }
}

