/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.sink.adapter;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.LifecycleHandler;
import io.awspring.cloud.sqs.listener.ContainerOptions;
import io.awspring.cloud.sqs.listener.SqsAsyncClientAware;
import io.awspring.cloud.sqs.listener.TaskExecutorAware;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingPipeline;
import io.awspring.cloud.sqs.listener.sink.MessageProcessingPipelineSink;
import io.awspring.cloud.sqs.listener.sink.MessageSink;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public abstract class AbstractDelegatingMessageListeningSinkAdapter<T>
implements MessageProcessingPipelineSink<T>,
TaskExecutorAware,
SqsAsyncClientAware {
    private final MessageSink<T> delegate;

    protected AbstractDelegatingMessageListeningSinkAdapter(MessageSink<T> delegate) {
        Assert.notNull(delegate, (String)"delegate cannot be null");
        this.delegate = delegate;
    }

    @Override
    public void setMessagePipeline(MessageProcessingPipeline<T> messageProcessingPipeline) {
        ConfigUtils.INSTANCE.acceptIfInstance(this.delegate, MessageProcessingPipelineSink.class, mpps -> mpps.setMessagePipeline(messageProcessingPipeline));
    }

    @Override
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        ConfigUtils.INSTANCE.acceptIfInstance(this.delegate, TaskExecutorAware.class, ea -> ea.setTaskExecutor(taskExecutor));
    }

    @Override
    public void setSqsAsyncClient(SqsAsyncClient sqsAsyncClient) {
        ConfigUtils.INSTANCE.acceptIfInstance(this.delegate, SqsAsyncClientAware.class, saca -> saca.setSqsAsyncClient(sqsAsyncClient));
    }

    public void start() {
        LifecycleHandler.get().start(this.delegate);
    }

    public void stop() {
        LifecycleHandler.get().stop(this.delegate);
    }

    public boolean isRunning() {
        return LifecycleHandler.get().isRunning(this.delegate);
    }

    public void configure(ContainerOptions containerOptions) {
        this.delegate.configure(containerOptions);
    }

    protected MessageSink<T> getDelegate() {
        return this.delegate;
    }
}

