/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.adapter;

import io.awspring.cloud.sqs.CompletableFutures;
import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.adapter.AbstractMethodInvokingListenerAdapter;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class AsyncMessagingMessageListenerAdapter<T>
extends AbstractMethodInvokingListenerAdapter<T>
implements AsyncMessageListener<T> {
    public AsyncMessagingMessageListenerAdapter(InvocableHandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    @Override
    public CompletableFuture<Void> onMessage(Message<T> message) {
        try {
            return CompletableFutures.exceptionallyCompose(this.invokeAsync(message), t -> CompletableFutures.failedFuture(this.createListenerException(message, (Throwable)t)));
        }
        catch (ClassCastException e) {
            return CompletableFutures.failedFuture(new IllegalArgumentException("Invalid return type for message " + MessageHeaderUtils.getId(message), e));
        }
        catch (Exception e) {
            return CompletableFutures.failedFuture(e);
        }
    }

    private CompletableFuture<Void> invokeAsync(Message<T> message) {
        return (CompletableFuture)super.invokeHandler(message);
    }

    @Override
    public CompletableFuture<Void> onMessage(Collection<Message<T>> messages) {
        try {
            return CompletableFutures.exceptionallyCompose(this.invokeAsync(messages), t -> CompletableFutures.failedFuture(this.createListenerException(messages, (Throwable)t)));
        }
        catch (ClassCastException e) {
            return CompletableFutures.failedFuture(new IllegalArgumentException("Invalid return type for messages " + MessageHeaderUtils.getId(messages), e));
        }
        catch (Exception e) {
            return CompletableFutures.failedFuture(e);
        }
    }

    private CompletableFuture<Void> invokeAsync(Collection<Message<T>> messages) {
        return (CompletableFuture)super.invokeHandler(messages);
    }
}

