/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.MessageListenerContainerFactory;
import io.awspring.cloud.sqs.listener.MessageListenerContainer;
import io.awspring.cloud.sqs.listener.MessageListenerContainerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EndpointRegistrar
implements BeanFactoryAware,
SmartInitializingSingleton {
    private static final Logger logger = LoggerFactory.getLogger(EndpointRegistrar.class);
    public static final String DEFAULT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "defaultSqsListenerContainerFactory";
    private BeanFactory beanFactory;
    private MessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
    private MessageListenerContainerRegistry listenerContainerRegistry;
    private String messageListenerContainerRegistryBeanName;
    private String defaultListenerContainerFactoryBeanName = "defaultSqsListenerContainerFactory";
    private final Collection<Endpoint> endpoints = new ArrayList<Endpoint>();
    private Consumer<List<MessageConverter>> messageConvertersConsumer = converters -> {};
    private Consumer<List<HandlerMethodArgumentResolver>> methodArgumentResolversConsumer = resolvers -> {};
    private ObjectMapper objectMapper;

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        Assert.notNull((Object)messageHandlerMethodFactory, (String)"messageHandlerMethodFactory cannot be null");
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setListenerContainerRegistry(MessageListenerContainerRegistry listenerContainerRegistry) {
        Assert.notNull((Object)listenerContainerRegistry, (String)"listenerContainerRegistry cannot be null");
        this.listenerContainerRegistry = listenerContainerRegistry;
    }

    public void setDefaultListenerContainerFactoryBeanName(String defaultListenerContainerFactoryBeanName) {
        Assert.isTrue((boolean)StringUtils.hasText((String)defaultListenerContainerFactoryBeanName), (String)"defaultListenerContainerFactoryBeanName must have text");
        this.defaultListenerContainerFactoryBeanName = defaultListenerContainerFactoryBeanName;
    }

    public void setMessageListenerContainerRegistryBeanName(String messageListenerContainerRegistryBeanName) {
        Assert.isTrue((boolean)StringUtils.hasText((String)messageListenerContainerRegistryBeanName), (String)"messageListenerContainerRegistryBeanName must have text");
        this.messageListenerContainerRegistryBeanName = messageListenerContainerRegistryBeanName;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null.");
        this.objectMapper = objectMapper;
    }

    public void manageMessageConverters(Consumer<List<MessageConverter>> convertersConsumer) {
        Assert.notNull(convertersConsumer, (String)"convertersConsumer cannot be null");
        this.messageConvertersConsumer = convertersConsumer;
    }

    public void manageMethodArgumentResolvers(Consumer<List<HandlerMethodArgumentResolver>> resolversConsumer) {
        Assert.notNull(resolversConsumer, (String)"resolversConsumer cannot be null");
        this.methodArgumentResolversConsumer = resolversConsumer;
    }

    public Consumer<List<MessageConverter>> getMessageConverterConsumer() {
        return this.messageConvertersConsumer;
    }

    public Consumer<List<HandlerMethodArgumentResolver>> getMethodArgumentResolversConsumer() {
        return this.methodArgumentResolversConsumer;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void registerEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void afterSingletonsInstantiated() {
        if (this.listenerContainerRegistry == null) {
            Assert.hasText((String)this.messageListenerContainerRegistryBeanName, (String)"messageListenerContainerRegistryBeanName not set");
            this.listenerContainerRegistry = (MessageListenerContainerRegistry)this.beanFactory.getBean(this.messageListenerContainerRegistryBeanName, MessageListenerContainerRegistry.class);
        }
        this.endpoints.forEach(this::process);
    }

    private void process(Endpoint endpoint) {
        logger.debug("Processing endpoint {}", (Object)endpoint.getId());
        this.listenerContainerRegistry.registerListenerContainer(this.createContainerFor(endpoint));
    }

    private MessageListenerContainer<?> createContainerFor(Endpoint endpoint) {
        String factoryBeanName = this.getListenerContainerFactoryName(endpoint);
        Assert.isTrue((boolean)this.beanFactory.containsBean(factoryBeanName), () -> "No MessageListenerContainerFactory bean with name " + factoryBeanName + " found for endpoint names " + endpoint.getLogicalNames());
        return ((MessageListenerContainerFactory)this.beanFactory.getBean(factoryBeanName, MessageListenerContainerFactory.class)).createContainer(endpoint);
    }

    private String getListenerContainerFactoryName(Endpoint endpoint) {
        return StringUtils.hasText((String)endpoint.getListenerContainerFactoryName()) ? endpoint.getListenerContainerFactoryName() : this.defaultListenerContainerFactoryBeanName;
    }
}

