/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs;

import io.awspring.cloud.sqs.SqsException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class SqsAcknowledgementException
extends SqsException {
    private final String queue;
    private final Collection<Message<?>> failedAcknowledgementMessages;
    private final Collection<Message<?>> successfullyAcknowledgedMessages;

    public SqsAcknowledgementException(String errorMessage, Collection<Message<?>> successfullyAcknowledgedMessages, Collection<Message<?>> failedAcknowledgementMessages, String queue) {
        this(errorMessage, successfullyAcknowledgedMessages, failedAcknowledgementMessages, queue, null);
    }

    public SqsAcknowledgementException(String errorMessage, Collection<Message<?>> successfullyAcknowledgedMessages, Collection<Message<?>> failedAcknowledgementMessages, String queue, @Nullable Throwable cause) {
        super(errorMessage, cause);
        this.queue = queue;
        this.failedAcknowledgementMessages = failedAcknowledgementMessages.stream().map(msg -> msg).collect(Collectors.toList());
        this.successfullyAcknowledgedMessages = successfullyAcknowledgedMessages.stream().map(msg -> msg).collect(Collectors.toList());
    }

    public Collection<Message<?>> getFailedAcknowledgementMessages() {
        return this.failedAcknowledgementMessages;
    }

    public Collection<Message<?>> getSuccessfullyAcknowledgedMessages() {
        return this.successfullyAcknowledgedMessages;
    }

    public String getQueue() {
        return this.queue;
    }
}

